/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.model.designer.IR1Page;
import kd.bos.print.core.model.designer.common.AbstractElement;
import kd.bos.print.core.model.ui.component.BasicPainter;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.Page;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.util.StringUtils;

public class WidgetLayerHelpUtils {
    private static final Log log = LogFactory.getLog(WidgetLayerHelpUtils.class);

    private WidgetLayerHelpUtils() {
    }

    public static Map<String, Integer> recordPageWidgetLayer(List<IR1Page> designPages) {
        HashMap<String, Integer> widgetLayerMap = new HashMap<String, Integer>(16);
        int layer = 0;
        for (IR1Page designPage : designPages) {
            List widgets = designPage.getChildren();
            for (AbstractElement widget : widgets) {
                widgetLayerMap.put(widget.getId(), layer);
                ++layer;
            }
        }
        return widgetLayerMap;
    }

    public static void sortPWPageChild(Map<String, Integer> widgetLayerMap, List<PWPage> pwPages) {
        try {
            for (PWPage pwPage : pwPages) {
                String pageId = pwPage.getId();
                List children = pwPage.getChildren();
                if (StringUtils.isBlank((String)pageId) || children == null || children.isEmpty()) continue;
                children.sort((o1, o2) -> {
                    int indexOne = widgetLayerMap.getOrDefault(o1.getId(), 0);
                    int indexTwo = widgetLayerMap.getOrDefault(o2.getId(), 0);
                    return indexOne - indexTwo;
                });
            }
        }
        catch (Exception ignore) {
            log.warn("\u63a7\u4ef6\u7ed8\u5236\u524d\u8fdb\u884c\u6392\u5e8f\u51fa\u73b0\u5f02\u5e38", (Throwable)ignore);
        }
    }

    public static Map<String, List<String>> initPageWidgetLayer(List<IR1Page> designPages) {
        HashMap<String, List<String>> pageWidgetsMap = new HashMap<String, List<String>>(16);
        for (IR1Page designPage : designPages) {
            ArrayList<String> widgetIds = new ArrayList<String>(10);
            String pageId = designPage.getId();
            List widgets = designPage.getChildren();
            for (AbstractElement widget : widgets) {
                widgetIds.add(widget.getId());
            }
            pageWidgetsMap.put(pageId, widgetIds);
        }
        return pageWidgetsMap;
    }

    public static void sortWidget(Map<String, List<String>> pageWidgetsMap, IPainter viewPage, String pageId) {
        try {
            Page page = (Page)viewPage;
            Map<Integer, Object> children = page.getChildrenMap();
            final List<String> orderRule = pageWidgetsMap.get(pageId);
            if (orderRule != null && !orderRule.isEmpty() && children != null && !children.isEmpty()) {
                for (Map.Entry<Integer, Object> entry : children.entrySet()) {
                    List widgets = (List)entry.getValue();
                    if (CollectionUtils.isEmpty((Collection)widgets)) continue;
                    Collections.sort(widgets, new Comparator<BasicPainter>(){

                        @Override
                        public int compare(BasicPainter o1, BasicPainter o2) {
                            int indexOne = orderRule.indexOf(o1.getId());
                            int indexTwo = orderRule.indexOf(o2.getId());
                            return indexOne - indexTwo;
                        }
                    });
                }
            }
        }
        catch (Exception ignore) {
            log.warn("\u63a7\u4ef6\u7ed8\u5236\u524d\u8fdb\u884c\u6392\u5e8f\u51fa\u73b0\u5f02\u5e38", (Throwable)ignore);
        }
    }
}

