/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.compute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.execute.compute.PrintPageCompute;
import kd.bos.print.core.execute.qrender.ClientCaptain;
import kd.bos.print.core.execute.qrender.ClientTotalPageCaptain;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumUtil;
import kd.bos.svc.acl.AclAdapter;

public class ClientPageCompute
extends PrintPageCompute {
    private boolean hasEcomic;
    private static final DistributeSessionlessCache DISTRIBUTE_CACHE = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    public static final String CACHE_PREV = "cPrintInfo";
    private final Map<String, List<Object>> formId2PkIds = new HashMap<String, List<Object>>(8);

    public ClientPageCompute(List<RuntimeModel> runModelList) {
        super(runModelList);
        for (RuntimeModel runtimeModel : runModelList) {
            String formId = runtimeModel.getFormId();
            List<Object> pkIds = this.formId2PkIds.get(formId);
            if (pkIds != null) {
                pkIds.addAll(runtimeModel.getPkIds());
                pkIds = pkIds.stream().distinct().collect(Collectors.toList());
            } else {
                pkIds = runtimeModel.getPkIds();
            }
            if (pkIds == null) continue;
            this.formId2PkIds.put(formId, new ArrayList<Object>(pkIds));
        }
    }

    @Override
    protected RenderCaptain createPainterCaptain() {
        String pageNumType = ExecuteContext.get().getPageNumType();
        if ("2".equals(pageNumType) && PageNumUtil.hasTotalWidget(this.runModelList)) {
            this.hasEcomic = PageNumUtil.hasEconomize(this.runModelList);
            return new ClientTotalPageCaptain(this.executeLife);
        }
        return new ClientCaptain(this.executeLife);
    }

    @Override
    protected void compute() throws Exception {
        super.compute();
        if (this.hasEcomic && this.renderCaptain instanceof ClientTotalPageCaptain) {
            ((ClientTotalPageCaptain)this.renderCaptain).setPageSize(this.pageObject.getTotalPageNum());
        }
    }

    @Override
    protected void handDelayVar() {
        if (!(this.renderCaptain instanceof ClientTotalPageCaptain)) {
            super.handDelayVar();
        }
    }

    @Override
    protected void executeOne(int pageWidth, int pageHeight, RuntimeModel runtimeModel, PaintPaperInfo paperInfo) throws Exception {
        super.executeOne(pageWidth, pageHeight, runtimeModel, paperInfo);
    }

    @Override
    protected void afterExecuteOne(RuntimeModel runtimeModel, PaintPaperInfo paperInfo, boolean isLastOne) throws Exception {
        super.afterExecuteOne(runtimeModel, paperInfo, isLastOne);
        ClientCaptain renderCaptain = (ClientCaptain)this.getRenderCaptain();
        renderCaptain.finishOne(isLastOne);
    }

    @Override
    protected void endCompute() {
        super.endCompute();
        String taskId = ExecuteContext.get().getTaskId();
        DISTRIBUTE_CACHE.put(CACHE_PREV + taskId, (Object)SerializationUtils.toJsonString(this.formId2PkIds), 8, TimeUnit.HOURS);
    }
}

