/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.compute;

import java.util.List;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.execute.compute.EcomizePaperProcess;
import kd.bos.print.core.execute.compute.ImagePageCompute;
import kd.bos.print.core.execute.compute.PaperProcess;
import kd.bos.print.core.execute.render.ClientPreviewRenderCaptain;
import kd.bos.print.core.execute.render.ClientPreviewTotalPageCaptain;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.utils.PrintConst;

public class ClientPagePreviewCompute
extends ImagePageCompute {
    private boolean isPageTotal;
    private boolean hasEcomicProcess;

    public ClientPagePreviewCompute(List<RuntimeModel> runModelList, boolean isPageTotal) {
        super(runModelList);
        this.isPageTotal = isPageTotal;
        this.renderCaptain = this.createPainterCaptain();
    }

    @Override
    protected RenderCaptain createPainterCaptain() {
        this.renderCaptain = this.isPageTotal ? new ClientPreviewTotalPageCaptain(this.executeLife) : new ClientPreviewRenderCaptain(this.executeLife);
        return this.renderCaptain;
    }

    @Override
    protected PaperProcess createPaperProcess(R1PrintInfo r1PrintInfo) {
        PaperProcess paperProcess = super.createPaperProcess(r1PrintInfo);
        if (paperProcess instanceof EcomizePaperProcess) {
            this.hasEcomicProcess = true;
        }
        return paperProcess;
    }

    @Override
    protected void handDelayVar() {
        if (!this.isPageTotal()) {
            this.executeHelper.getDelayVarProvider().fillValue("pageTotal", new IntegerField(this.pageObject.getTotalPageNum()));
        }
    }

    @Override
    protected void endCompute() {
        int totalPageNum = this.pageObject.getTotalPageNum();
        if (!this.hasEcomicProcess && totalPageNum > PrintConst.getMaxPreviewNum()) {
            totalPageNum = PrintConst.getMaxPreviewNum();
        }
        this.getPreviewRenderCaptain().endPut(totalPageNum);
    }

    private ClientPreviewRenderCaptain getPreviewRenderCaptain() {
        return (ClientPreviewRenderCaptain)this.renderCaptain;
    }

    private boolean isPageTotal() {
        return this.isPageTotal;
    }
}

