/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.compute;

import java.util.HashMap;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.execute.compute.PrintPageCompute;
import kd.bos.print.core.execute.render.DiskRenderCaptain;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumUtil;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumWidget;
import kd.bos.print.core.model.widget.PWPage;

public class DiskPageCompute
extends PrintPageCompute {
    private static Log log = LogFactory.getLog(DiskPageCompute.class);

    public DiskPageCompute(List<RuntimeModel> runModelList) {
        super(runModelList);
    }

    @Override
    protected RenderCaptain createPainterCaptain() {
        return new DiskRenderCaptain(this.getExecuteLife());
    }

    @Override
    protected void compute() throws Exception {
        try {
            this.renameFileName();
            HashMap<String, PageNumWidget> pageNumWidgets = new HashMap<String, PageNumWidget>(8);
            for (RuntimeModel runtimeModel : this.runModelList) {
                if (this.executeLife.isStop()) {
                    log.info("\u5916\u90e8\u5f3a\u5236\u7ec8\u6b62\uff0c\u8ba1\u7b97\u7ebf\u7a0b\u5c06\u505c\u6b62\u8fd0\u884c\u3002");
                    break;
                }
                R1PrintInfo r1PrintInfo = runtimeModel.getReportModel().getR1PrintInfo();
                ExecuteContext.get().setTplVer(runtimeModel.getTplVer());
                ExecuteContext.get().setTplId(runtimeModel.getTplId());
                ExecuteContext.get().setTplKey(runtimeModel.getTplKey());
                this.paperProcess = this.createPaperProcess(r1PrintInfo);
                if (r1PrintInfo.isDynamicPaper()) {
                    r1PrintInfo.setPaperHeight(297000);
                }
                List<PWPage> pwPages = this.importPage(runtimeModel);
                PageNumUtil.recoreTotalWidget(pwPages, r1PrintInfo.getMarginLeft(), r1PrintInfo.getMarginTop(), r1PrintInfo.getPaperSize().width, r1PrintInfo.getPaperSize().height, pageNumWidgets);
                PaintPaperInfo paperInfo = this.getPaperInfo(runtimeModel);
                this.compute(runtimeModel, paperInfo);
                runtimeModel.clear();
                this.paperProcess.endProcess(this.renderCaptain);
            }
            ((DiskRenderCaptain)this.renderCaptain).getPageNumRecord().setPageNumWidgetMap(pageNumWidgets);
            this.computeEndProcess();
        }
        catch (Throwable throwable) {
            log.error("\u8ba1\u7b97\u7ebf\u7a0b\u5f02\u5e38", throwable);
            this.executeLife.setComputeErr();
            throw throwable;
        }
    }

    protected void computeEndProcess() {
    }

    @Override
    protected void handDelayVar() {
    }
}

