/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.compute;

import java.awt.Rectangle;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.compute.PaperProcess;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;

public class DynamicPaperProcess
extends PaperProcess {
    @Override
    public void addPage(RenderCaptain renderCaptain, PWPage pwPage, PaintPaperInfo paperInfo) throws InterruptedException {
        R1PrintInfo r1PrintInfo = paperInfo.getR1PrintInfo();
        if (!r1PrintInfo.isDynamicPaper()) {
            return;
        }
        AbstractPrintWidget footerWidget = PWidgetUtil.findFooterPage(pwPage);
        AbstractPrintWidget buttomWidget = PWidgetUtil.findButtomWidget(pwPage);
        int buttomWidgetHeight = 0;
        if (buttomWidget != null) {
            buttomWidgetHeight = buttomWidget.getRectangle().height;
            if (buttomWidget instanceof AbstractPWGrid && ((AbstractPWGrid)buttomWidget).getOutputRows() != null) {
                buttomWidgetHeight = ((AbstractPWGrid)buttomWidget).getOutputRows().stream().mapToInt(m -> ((AbstractPWGridRow)m).getHeight()).sum();
            }
        }
        if (footerWidget != null && buttomWidget != null) {
            int maxY2;
            Rectangle rectangle = footerWidget.getRectangle();
            rectangle.y = maxY2 = buttomWidget.getRectangle().y + buttomWidgetHeight;
            buttomWidget = footerWidget;
            buttomWidgetHeight = footerWidget.getRectangle().height;
        }
        PaintPaperInfo newPaintPaperInfo = paperInfo.copy();
        R1PrintInfo newR1PrintInfo = new R1PrintInfo(r1PrintInfo);
        newPaintPaperInfo.setR1PrintInfo(newR1PrintInfo);
        if (buttomWidget == null) {
            int pageHeight;
            pwPage.getRectangle().height = pageHeight = newR1PrintInfo.getMarginTop() + newR1PrintInfo.getMarginBottom();
            newR1PrintInfo.setPaperHeight(pageHeight + 10);
        } else {
            int maxY2 = buttomWidget.getRectangle().y + buttomWidgetHeight;
            newR1PrintInfo.setPaperHeight(maxY2 + newR1PrintInfo.getMarginTop() + newR1PrintInfo.getMarginBottom());
            pwPage.getRectangle().height = maxY2;
        }
        super.addPage(renderCaptain, pwPage, newPaintPaperInfo);
    }
}

