/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.compute;

import java.awt.Rectangle;
import java.util.List;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.execute.compute.PaperProcess;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.unitest.PrintUntiTestPluginProxy;
import org.apache.commons.lang3.StringUtils;

public class EcomizePaperProcess
extends PaperProcess {
    private EcomizePaper ecomizePaper = new EcomizePaper();
    private int pageNum;
    private boolean isVerEconomizePaperValue;
    private boolean isHorEconomizePaperValue;

    public EcomizePaperProcess() {
    }

    public EcomizePaperProcess(boolean isHorEconomizePaperValue, boolean isVerEconomizePaperValue) {
        this.isHorEconomizePaperValue = isHorEconomizePaperValue;
        this.isVerEconomizePaperValue = isVerEconomizePaperValue;
    }

    @Override
    public void addPage(RenderCaptain renderCaptain, PWPage pwPage, PaintPaperInfo paperInfo) throws InterruptedException {
        if (pwPage.getChildren() == null || pwPage.getChildren().isEmpty()) {
            return;
        }
        if (this.ecomizePaper.getPaperPainter() == null) {
            APaperPainter<PWPage> lastPaperPainter = this.createPaperPainter(renderCaptain, paperInfo);
            lastPaperPainter.addPaintObj(pwPage);
            this.ecomizePaper.setPaperPainter(lastPaperPainter);
            React curReact = new React(0, 0, 0, 0);
            FooterInfo footerInfo = EcomizePaperProcess.injectReactAndGetHeaderFooterInfo(pwPage, curReact, 0);
            this.ecomizePaper.setStartY(footerInfo.getHeaderHeight());
            return;
        }
        React curReact = new React(0, 0, 0, 0);
        FooterInfo footerInfo = EcomizePaperProcess.injectReactAndGetHeaderFooterInfo(pwPage, curReact, 0);
        React prevReact = this.ecomizePaper.getContentArea();
        Rectangle pageRectangle = this.ecomizePaper.getPageRectangle();
        if (this.isHorEconomizePaperValue && pageRectangle.width - prevReact.getX2() >= curReact.getX2() && pageRectangle.height - this.ecomizePaper.getStartY() >= curReact.getY2() - footerInfo.getHeaderHeight()) {
            this.addPage2LastPage(pwPage, prevReact.getX2(), this.ecomizePaper.startY, 0);
            return;
        }
        if (this.isVerEconomizePaperValue && pageRectangle.height - prevReact.getY2() - prevReact.getFooterInfo().getFooterHeight() >= curReact.getY2() && pageRectangle.width >= curReact.getX2()) {
            this.addPage2LastPage(pwPage, 0, prevReact.getY2(), footerInfo.getHeaderHeight());
            this.ecomizePaper.startY = prevReact.getY2() - footerInfo.getHeaderHeight();
            return;
        }
        this.addPageToConsume(renderCaptain, this.ecomizePaper.getPaperPainter());
        this.reset();
        this.addPage(renderCaptain, pwPage, paperInfo);
    }

    private void addPageToConsume(RenderCaptain renderCaptain, APaperPainter<PWPage> paperPainter) throws InterruptedException {
        ++this.pageNum;
        PWPage paintObj = (PWPage)paperPainter.getPaintObj();
        EcomizePaperProcess.fillPageNum(paintObj.getChildren(), this.pageNum);
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            pluginProxy.fireUnitestPlugin(PrintUntiTestPluginProxy.Method.BeforeDrawPage, paperPainter);
        }
        renderCaptain.put(paperPainter);
    }

    @Override
    public void endProcess(RenderCaptain renderCaptain) throws InterruptedException {
        APaperPainter paperPainter = this.ecomizePaper.getPaperPainter();
        if (paperPainter != null) {
            this.addPageToConsume(renderCaptain, paperPainter);
            this.ecomizePaper.setPaperPainter(null);
        }
    }

    private static boolean isPageNumWidget(IPrintWidget widget) {
        if (!(widget instanceof PWText)) {
            return false;
        }
        PWText pwText = (PWText)widget;
        String datasource = pwText.getDatasource();
        String bindField = pwText.getBindField();
        if (!StringUtil.equals(datasource, "$DsKey=[System]") || !StringUtils.isNotBlank((CharSequence)bindField)) {
            return false;
        }
        return bindField.contains("getPageNumber()");
    }

    private static void fillPageNum(List<IPrintWidget> widgets, int pageNum) {
        if (widgets == null || widgets.isEmpty()) {
            return;
        }
        for (IPrintWidget widget : widgets) {
            if (EcomizePaperProcess.isPageNumWidget(widget)) {
                PWText pwText = (PWText)widget;
                if (!StringUtils.isNotBlank((CharSequence)pwText.getOutputText())) continue;
                pwText.setOutputText(pwText.getOutputText().replace(DelayVarProvider.makeVarSign("pageNumber"), String.valueOf(pageNum)));
                continue;
            }
            if (widget instanceof IPrintWidgetContainer) {
                IPrintWidgetContainer container = (IPrintWidgetContainer)widget;
                List children = container.getChildren();
                EcomizePaperProcess.fillPageNum(children, pageNum);
                continue;
            }
            if (!(widget instanceof AbstractPWGrid)) continue;
            AbstractPWGrid layoutGrid = (AbstractPWGrid)widget;
            List outputRows = layoutGrid.getOutputRows();
            int columnCount = layoutGrid.getColumnCount();
            for (int i = 0; i < outputRows.size(); ++i) {
                AbstractPWGridRow row = (AbstractPWGridRow)outputRows.get(i);
                for (int j = 0; j < columnCount; ++j) {
                    Object cell = row.getCell(j);
                    if (cell == null) continue;
                    if (EcomizePaperProcess.isPageNumWidget(cell)) {
                        Object pwText = cell;
                        if (!StringUtils.isNotBlank((CharSequence)((AbstractPrintWidgetText)cell).getOutputText())) continue;
                        ((AbstractPrintWidgetText)pwText).setOutputText(((AbstractPrintWidgetText)cell).getOutputText().replace(DelayVarProvider.makeVarSign("pageNumber"), String.valueOf(pageNum)));
                        continue;
                    }
                    List<IPrintWidget> children = ((AbstractPWGridCell)cell).getChildren();
                    EcomizePaperProcess.fillPageNum(children, pageNum);
                }
            }
        }
    }

    private void reset() {
        this.ecomizePaper.setPaperPainter(null);
        this.ecomizePaper.setStartY(0);
    }

    private void addPage2LastPage(PWPage curPage, int xScare, int yScare, int headerY) {
        List children = curPage.getChildren();
        for (AbstractPrintWidget widget : children) {
            if (widget instanceof PWFooter) continue;
            if (widget.getPrintAtPage() == PrintAtPage.All) {
                widget = PWidgetUtil.widgetCopyWithOutputValue(widget);
            }
            Rectangle widgetRectangle = widget.getRectangle();
            widgetRectangle.x += xScare;
            widgetRectangle.y = widgetRectangle.y - headerY + yScare;
            this.ecomizePaper.addChild(widget);
        }
    }

    private static FooterInfo injectReactAndGetHeaderFooterInfo(PWPage pwPage, React react, int startY) {
        int maxX = 0;
        int maxY = 0;
        List children = pwPage.getChildren();
        FooterInfo footerInfo = new FooterInfo();
        for (AbstractPrintWidget widget : children) {
            Rectangle rectangle = widget.getRectangle();
            if (rectangle.y < startY) continue;
            if (widget instanceof PWFooter) {
                if ("Footer".equals(widget.getType())) {
                    footerInfo.setFooterHeight(rectangle.height);
                    continue;
                }
                if ("Header".equals(widget.getType())) {
                    footerInfo.setHeaderHeight(rectangle.height);
                }
            }
            int x = rectangle.x + rectangle.width;
            int y = EcomizePaperProcess.getRY2(widget);
            if (maxX < x && !(widget instanceof PWFooter)) {
                maxX = x;
            }
            if (maxY >= y) continue;
            maxY = y;
        }
        react.x1 = 0;
        react.x2 = maxX;
        react.y1 = 0;
        react.y2 = maxY;
        return footerInfo;
    }

    private static int getRY2(AbstractPrintWidget widget) {
        Rectangle rectangle = widget.getRectangle();
        if (!(widget instanceof AbstractPWGrid)) {
            return rectangle.y + rectangle.height;
        }
        AbstractPWGrid pwGrid = (AbstractPWGrid)widget;
        List outputRows = pwGrid.getOutputRows();
        int y2 = rectangle.y;
        for (AbstractPWGridRow row : outputRows) {
            y2 += row.getHeight();
        }
        return y2;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    private static class FooterInfo {
        private int headerHeight;
        private int footerHeight;

        private FooterInfo() {
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public void setHeaderHeight(int headerHeight) {
            this.headerHeight = headerHeight;
        }

        public int getFooterHeight() {
            return this.footerHeight;
        }

        public void setFooterHeight(int footerHeight) {
            this.footerHeight = footerHeight;
        }
    }

    private static class React {
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private FooterInfo footerInfo = new FooterInfo();

        public React(int x1, int x2, int y1, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public int getX1() {
            return this.x1;
        }

        public void setX1(int x1) {
            this.x1 = x1;
        }

        public int getY1() {
            return this.y1;
        }

        public void setY1(int y1) {
            this.y1 = y1;
        }

        public int getX2() {
            return this.x2;
        }

        public void setX2(int x2) {
            this.x2 = x2;
        }

        public int getY2() {
            return this.y2;
        }

        public void setY2(int y2) {
            this.y2 = y2;
        }

        public FooterInfo getFooterInfo() {
            return this.footerInfo;
        }

        public void setFooterInfo(FooterInfo footerInfo) {
            this.footerInfo = footerInfo;
        }
    }

    private static class EcomizePaper {
        private APaperPainter<PWPage> paperPainter;
        private int startY;

        private EcomizePaper() {
        }

        public APaperPainter getPaperPainter() {
            return this.paperPainter;
        }

        public void setPaperPainter(APaperPainter<PWPage> paperPainter) {
            this.paperPainter = paperPainter;
        }

        public void addChild(AbstractPrintWidget widget) {
            PWPage paintObj = (PWPage)this.paperPainter.getPaintObj();
            paintObj.getChildren().add(widget);
        }

        public Rectangle getPageRectangle() {
            PWPage paintObj = (PWPage)this.paperPainter.getPaintObj();
            Rectangle rectangle = paintObj.getRectangle();
            return rectangle;
        }

        public React getContentArea() {
            PWPage paintObj = (PWPage)this.paperPainter.getPaintObj();
            React react = new React(0, 0, 0, 0);
            FooterInfo footerInfo = EcomizePaperProcess.injectReactAndGetHeaderFooterInfo(paintObj, react, this.startY);
            react.setY1(this.startY);
            react.setFooterInfo(footerInfo);
            return react;
        }

        public int getStartY() {
            return this.startY;
        }

        public void setStartY(int startY) {
            this.startY = startY;
        }
    }
}

