/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.compute;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.PageObject;
import kd.bos.print.core.data.MainDataVisitor;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.execute.WidgetLayerHelpUtils;
import kd.bos.print.core.execute.compute.DynamicPaperProcess;
import kd.bos.print.core.execute.compute.EcomizePaperProcess;
import kd.bos.print.core.execute.compute.PaperProcess;
import kd.bos.print.core.execute.helper.ExecuteHelper;
import kd.bos.print.core.execute.importer.R1PrintD2WImporter;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.utils.PrtFileNameUtil;
import kd.bos.print.core.model.designer.IR1Page;
import kd.bos.print.core.model.designer.ReportModel;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWPageEnum;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.runner.IRunner;
import kd.bos.print.core.model.widget.runner.MulPageRelativeContext;
import kd.bos.print.core.model.widget.runner.RelativeContext;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.service.InteTimeZone;
import kd.bos.util.StringUtils;

public class PrintPageCompute
implements Callable<Object> {
    private static Log log = LogFactory.getLog(PrintPageCompute.class);
    protected RenderCaptain renderCaptain;
    protected ExecuteContext executeContext;
    protected PageObject pageObject = new PageObject();
    protected IWidgetExecuteHelper executeHelper;
    private R1PrintD2WImporter d2w = new R1PrintD2WImporter(null, null);
    protected List<RuntimeModel> runModelList;
    protected ExecuteLife executeLife = ExecuteLife.getOrCreate();
    protected DelayVarProvider delayVarProvider = new DelayVarProvider();
    protected PaperProcess paperProcess;
    protected Map widgetLayerMap;
    protected String fileName;
    private List<PWPage> onePWPageList = new ArrayList<PWPage>();

    public PrintPageCompute(List<RuntimeModel> runModelList) {
        this.runModelList = runModelList;
        this.renderCaptain = this.createPainterCaptain();
        this.executeContext = ExecuteContext.get();
    }

    public ExecuteLife getExecuteLife() {
        return this.executeLife;
    }

    protected RenderCaptain createPainterCaptain() {
        return new RenderCaptain(this.executeLife);
    }

    public RenderCaptain getRenderCaptain() {
        return this.renderCaptain;
    }

    @Override
    public Object call() throws Exception {
        try {
            ExecuteContext.set(this.executeContext);
            this.compute();
            this.endCompute();
        }
        finally {
            if (this.runModelList != null) {
                this.runModelList.clear();
                this.runModelList = null;
            }
        }
        return true;
    }

    protected void endCompute() {
    }

    protected void compute() throws Exception {
        try {
            this.renameFileName();
            int i = 0;
            for (RuntimeModel runtimeModel : this.runModelList) {
                if (this.executeLife.isStop() || this.executeLife.isStopCompute()) {
                    log.info("\u5916\u90e8\u5f3a\u5236\u7ec8\u6b62\uff0c\u8ba1\u7b97\u7ebf\u7a0b\u5c06\u505c\u6b62\u8fd0\u884c\u3002");
                    break;
                }
                R1PrintInfo pi = runtimeModel.getReportModel().getR1PrintInfo();
                ExecuteContext.get().setPluginProxy(runtimeModel.getPluginProxy());
                ExecuteContext.get().getServiceProxy().getDataService().setPluginProxy(runtimeModel.getPluginProxy());
                ExecuteContext.get().setTplVer(runtimeModel.getTplVer());
                ExecuteContext.get().setTplId(runtimeModel.getTplId());
                ExecuteContext.get().setTplKey(runtimeModel.getTplKey());
                if (i == this.runModelList.size() - 1) {
                    ExecuteContext.get().setLastRunModel(true);
                }
                this.paperProcess = this.createPaperProcess(pi);
                if (pi.isDynamicPaper()) {
                    pi.setPaperHeight(297000);
                }
                PaintPaperInfo paperInfo = this.getPaperInfo(runtimeModel);
                this.compute(runtimeModel, paperInfo);
                runtimeModel.clear();
                if (ExecuteContext.get().isCalculateTotalPage()) continue;
                ++i;
            }
        }
        catch (Throwable throwable) {
            log.info("\u8ba1\u7b97\u7ebf\u7a0b\u5f02\u5e38", (Object)throwable);
            this.executeLife.setComputeErr();
            throw throwable;
        }
    }

    protected void compute(RuntimeModel runtimeModel, PaintPaperInfo paperInfo) throws Exception {
        this.executeHelper = new ExecuteHelper(runtimeModel);
        ((ExecuteHelper)this.executeHelper).setDelayVarProvider(this.delayVarProvider);
        String formId = runtimeModel.getFormId();
        ReportModel reportModel = runtimeModel.getReportModel();
        R1PrintInfo pi = reportModel.getR1PrintInfo();
        Dimension dim = pi.getPrintableAreaSize();
        this.widgetLayerMap = WidgetLayerHelpUtils.recordPageWidgetLayer(reportModel.getPages());
        if (StringUtils.isEmpty((String)formId)) {
            this.beforeExecuteOne(runtimeModel, paperInfo);
            if (StringUtils.isNotEmpty((String)this.fileName)) {
                paperInfo.setTplName(this.fileName);
            } else {
                paperInfo.setTplName(runtimeModel.getPdfName());
            }
            this.executeOne(dim.width, dim.height, runtimeModel, paperInfo);
            this.afterExecuteOne(runtimeModel, paperInfo, true);
        } else {
            MainDataVisitor dataVisitor = (MainDataVisitor)runtimeModel.getDataVisitor(formId);
            while (dataVisitor.hasNext()) {
                this.beforeExecuteOne(runtimeModel, paperInfo);
                if (this.executeLife.isStop() || this.executeLife.isStopCompute()) {
                    log.info("\u5916\u90e8\u5f3a\u5236\u7ec8\u6b62\uff0c\u8ba1\u7b97\u7ebf\u7a0b\u5c06\u505c\u6b62\u8fd0\u884c\u3002");
                    break;
                }
                if (!this.executeLife.isConsumeSuccess()) {
                    log.info("\u6d88\u8d39\u7ebf\u7a0b\u5f02\u5e38\uff0c\u8ba1\u7b97\u7ebf\u7a0b\u5c06\u505c\u6b62\u8ba1\u7b97\u3002");
                    break;
                }
                runtimeModel.beginInit();
                this.executeOne(dim.width, dim.height, runtimeModel, paperInfo);
                this.collectTotalPage(dataVisitor);
                dataVisitor.next();
                this.afterExecuteOne(runtimeModel, paperInfo, !dataVisitor.hasNext());
            }
        }
    }

    protected void beforeExecuteOne(RuntimeModel runtimeModel, PaintPaperInfo paperInfo) {
        if (ExecuteContext.get().isEconomizeByBill()) {
            this.paperProcess = this.createPaperProcess(runtimeModel.getReportModel().getR1PrintInfo());
        }
    }

    protected void afterExecuteOne(RuntimeModel runtimeModel, PaintPaperInfo paperInfo, boolean isLastOne) throws Exception {
        if (ExecuteContext.get().isEconomizeByBill()) {
            this.paperProcess.endProcess(this.renderCaptain);
        } else if (isLastOne) {
            this.paperProcess.endProcess(this.renderCaptain);
        }
    }

    protected void collectTotalPage(MainDataVisitor dataVisitor) {
    }

    protected PaintPaperInfo getPaperInfo(RuntimeModel runtimeModel) {
        PaintPaperInfo paperInfo = new PaintPaperInfo();
        R1PrintInfo r1PrintInfo = runtimeModel.getReportModel().getR1PrintInfo();
        paperInfo.setR1PrintInfo(r1PrintInfo);
        if (StringUtils.isEmpty((String)this.fileName)) {
            paperInfo.setTplName(runtimeModel.getPdfName());
        } else {
            paperInfo.setTplName(this.fileName);
        }
        paperInfo.setWaterMark(runtimeModel.getWaterMark());
        return paperInfo;
    }

    protected void executeOne(int pageWidth, int pageHeight, RuntimeModel runtimeModel, PaintPaperInfo paperInfo) throws Exception {
        this.pageObject.resetPage();
        List<PWPage> pwPages = this.importPage(runtimeModel);
        boolean splicePrint = runtimeModel.isSplicePrint();
        ExecuteContext.get().setSplicePrint(splicePrint);
        RelativeContext relativeContext = null;
        for (int index = 0; index < pwPages.size(); ++index) {
            PWPage page = pwPages.get(index);
            this.executeLife.doHeartBeat();
            page.getRectangle().setSize(pageWidth, pageHeight);
            int startPage = this.pageObject.getStartPage();
            if (splicePrint) {
                if (relativeContext == null) {
                    relativeContext = new MulPageRelativeContext(page, startPage, index);
                } else {
                    ((MulPageRelativeContext)relativeContext).update(page, startPage - 1, index);
                }
            } else {
                PWPage emptyPage = (PWPage)page.copy();
                emptyPage.setChildren(new ArrayList());
                relativeContext = new RelativeContext(emptyPage, startPage);
            }
            IRunner runner = page.getRunner();
            runner.setRelativeContext(relativeContext);
            runner.execute(this.executeHelper);
            Map<Integer, PWPage> pagePool = relativeContext.getPagePool();
            Map<String, List<AbstractPrintWidget>> widgetPool = relativeContext.getWidgetPool();
            List<AbstractPrintWidget> allPageWidgets = widgetPool.get(PrintAtPage.All.getCode());
            List<AbstractPrintWidget> lastPageWidgets = widgetPool.get(PrintAtPage.Last.getCode());
            boolean addAllWidget = false;
            for (Map.Entry<Integer, PWPage> entry : pagePool.entrySet()) {
                PWPage pwPage = entry.getValue();
                if (this.onePWPageList.contains(pwPage)) continue;
                addAllWidget = true;
                this.addWidgetToPage(pwPage, allPageWidgets);
                if (index != 0 && splicePrint && this.isEmptyPage(pwPage, pagePool, lastPageWidgets)) continue;
                this.pageObject.addPage();
                this.onePWPageList.add(pwPage);
            }
            if (!addAllWidget && (allPageWidgets != null && allPageWidgets.stream().anyMatch(f -> !(f instanceof PWFooter)) || !CollectionUtils.isEmpty(lastPageWidgets))) {
                PWPage emptyPage = (PWPage)page.copy();
                emptyPage.setRectangle(new Rectangle(page.getRectangle()));
                emptyPage.setPageIndex(this.onePWPageList.size());
                this.addWidgetToPage(emptyPage, allPageWidgets);
                this.pageObject.addPage();
                this.onePWPageList.add(emptyPage);
                pagePool.putIfAbsent(pagePool.size(), emptyPage);
                if (relativeContext instanceof MulPageRelativeContext) {
                    HashSet<String> widgetIds = new HashSet<String>(16);
                    if (allPageWidgets != null) {
                        widgetIds.addAll(allPageWidgets.stream().filter(Objects::nonNull).map(AbstractPrintWidget::getId).collect(Collectors.toSet()));
                    }
                    if (lastPageWidgets != null) {
                        widgetIds.addAll(lastPageWidgets.stream().filter(Objects::nonNull).map(AbstractPrintWidget::getId).collect(Collectors.toSet()));
                    }
                    ((MulPageRelativeContext)relativeContext).updateFixedControlPosition(widgetIds);
                }
            }
            if (!CollectionUtils.isEmpty(lastPageWidgets) && !CollectionUtils.isEmpty(this.onePWPageList)) {
                PWPage pwPage = this.onePWPageList.get(this.onePWPageList.size() - 1);
                this.addWidgetToPage(pwPage, lastPageWidgets);
                lastPageWidgets.clear();
            }
            relativeContext.finishDesignPage();
        }
        this.endExecuteOne(this.onePWPageList, paperInfo);
        if (relativeContext != null) {
            relativeContext.release();
        }
        this.executeLife.doHeartBeat();
    }

    private boolean isEmptyPage(PWPage pwPage, Map<Integer, PWPage> pagePool, List<AbstractPrintWidget> lastPageWidgets) {
        return !(!PWidgetUtil.isEmptyPage(pwPage) && !PWidgetUtil.isOnlyHeadFooterPage(pwPage) || pwPage.getPageIndex() == pagePool.size() - 1 && !CollectionUtils.isEmpty(lastPageWidgets));
    }

    private void endExecuteOne(List<PWPage> onePWPageList, PaintPaperInfo paperInfo) throws Exception {
        if (onePWPageList == null || onePWPageList.isEmpty()) {
            return;
        }
        if (this.pageObject.isPageSeparation() && onePWPageList.size() % 2 != 0 && !paperInfo.getR1PrintInfo().isDynamicPaper()) {
            onePWPageList.add(PWPageEnum.INSTANCE.getEmptyPage());
            String pageNumType = ExecuteContext.get().getPageNumType();
            if ("2".equals(pageNumType)) {
                this.pageObject.addPage();
            }
        }
        this.handDelayVar();
        WidgetLayerHelpUtils.sortPWPageChild(this.widgetLayerMap, onePWPageList);
        this.pagesProcess(onePWPageList, paperInfo);
        onePWPageList.clear();
    }

    protected void pagesProcess(List<PWPage> onePWPageList, PaintPaperInfo paperInfo) throws InterruptedException {
        for (PWPage pwPage : onePWPageList) {
            this.removeEmptyGrid(pwPage);
            this.paperProcess.addPage(this.renderCaptain, pwPage, paperInfo);
        }
    }

    private void removeEmptyGrid(PWPage pwPage) {
        if (pwPage != null && !CollectionUtils.isEmpty((Collection)pwPage.getChildren())) {
            List children = pwPage.getChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                AbstractPWGrid grid;
                AbstractPrintWidget widget = (AbstractPrintWidget)iterator.next();
                if (!(widget instanceof AbstractPWGrid) || !CollectionUtils.isEmpty((grid = (AbstractPWGrid)widget).getOutputRows())) continue;
                iterator.remove();
            }
        }
    }

    protected void handDelayVar() {
        this.executeHelper.getDelayVarProvider().fillValue("pageTotal", new IntegerField(this.pageObject.getTotalPageNum()));
    }

    protected PaperProcess createPaperProcess(R1PrintInfo r1PrintInfo) {
        if (r1PrintInfo.isHorEconomizePaper() || r1PrintInfo.isVerEconomizePaper()) {
            return new EcomizePaperProcess(r1PrintInfo.isHorEconomizePaper(), r1PrintInfo.isVerEconomizePaper());
        }
        if (r1PrintInfo.isDynamicPaper()) {
            return new DynamicPaperProcess();
        }
        return new PaperProcess();
    }

    protected List<PWPage> importPage(RuntimeModel runtimeModel) {
        List<IR1Page> designPages = runtimeModel.getReportModel().getPages();
        ArrayList<PWPage> pwPages = new ArrayList<PWPage>(10);
        for (IR1Page designPage : designPages) {
            IPrintWidget widget = this.d2w.translate(designPage);
            PWPage pwp = (PWPage)widget;
            pwp.setFooterHeight(designPage.getFooterHeight());
            pwPages.add(pwp);
        }
        return pwPages;
    }

    private void addWidgetToPage(PWPage pwPage, List<AbstractPrintWidget> widgets) {
        if (widgets == null) {
            return;
        }
        for (AbstractPrintWidget widget : widgets) {
            this.addWidgetToPage(pwPage, widget);
        }
    }

    protected void addWidgetToPage(PWPage pwPage, AbstractPrintWidget widget) {
        PWText pwText;
        String datasource;
        if (widget == null) {
            return;
        }
        widget.setPageIndex(pwPage.getPageIndex());
        if (widget instanceof PWFooter) {
            PWFooter pwFooter = (PWFooter)widget;
            List children = pwFooter.getChildren();
            if (children == null || children.isEmpty()) {
                pwPage.addChildNoHide(widget);
                return;
            }
            PWFooter copyFooter = (PWFooter)pwFooter.copy();
            ArrayList<IPrintWidget> outPutChildren = new ArrayList<IPrintWidget>(10);
            for (AbstractPrintWidget child : children) {
                if (child.isHideMove()) continue;
                child.setPageIndex(pwPage.getPageIndex());
                AbstractPrintWidget outPutWidget = this.fireAfterOutputWidget(child);
                outPutChildren.add(outPutWidget);
            }
            copyFooter.setChildren(outPutChildren);
            pwPage.addChildNoHide(copyFooter);
            return;
        }
        if (widget instanceof PWText && StringUtil.equals(datasource = (pwText = (PWText)widget).getDatasource(), "$DsKey=[System]")) {
            PWText copy = (PWText)pwText.copy();
            Object formulaResult = PrintPageCompute.runFormula(this.executeHelper, copy, copy.getBindField());
            IRunner runner = copy.getRunner();
            if (runner instanceof TextRunner && !DelayVarProvider.isVar(String.valueOf(formulaResult)) && pwText.isNeedFormat()) {
                TextRunner textRunner = (TextRunner)runner;
                Field textField = new TextField(formulaResult == null ? "" : formulaResult.toString());
                textField = textRunner.formatOutputValue(textField);
                formulaResult = textField;
            }
            copy.setOutputText(Optional.ofNullable(formulaResult).map(Object::toString).orElse(null));
            pwPage.addChildNoHide(copy);
            return;
        }
        pwPage.addChildNoHide(this.fireAfterOutputWidget(widget));
    }

    private AbstractPrintWidget fireAfterOutputWidget(AbstractPrintWidget widget) {
        PrintPluginProxy pluginProxy;
        PWText pwText;
        String datasource;
        boolean isCopy = false;
        AbstractPrintWidget outPutWidget = widget;
        if (outPutWidget instanceof PWText && StringUtil.equals(datasource = (pwText = (PWText)outPutWidget).getDatasource(), "$DsKey=[System]")) {
            PWText copy = (PWText)pwText.copy();
            if ("=now()".equals(pwText.getBindField()) && ("Date".equals(pwText.getTextFormat()) || "Time".equals(pwText.getTextFormat()))) {
                copy.setOutputText(pwText.getOutputText());
            } else {
                Object formulaResult = PrintPageCompute.runFormula(this.executeHelper, copy, copy.getBindField());
                copy.setOutputText(Optional.ofNullable(formulaResult).map(Object::toString).orElse(null));
            }
            outPutWidget = copy;
            isCopy = true;
        }
        if ((pluginProxy = ExecuteContext.get().getPluginProxy()) == null) {
            return outPutWidget;
        }
        AfterOutputWidgetEvent<AbstractPrintWidget> evt = new AfterOutputWidgetEvent<AbstractPrintWidget>(outPutWidget);
        pluginProxy.fireAfterOutputWidget(evt);
        Field modifyValue = evt.getModifyValue();
        if (modifyValue == null) {
            return outPutWidget;
        }
        if (!isCopy) {
            outPutWidget = (AbstractPrintWidget)outPutWidget.copy();
        }
        this.setWidgetValue(outPutWidget, modifyValue);
        return outPutWidget;
    }

    private void setWidgetValue(AbstractPrintWidget widget, Field field) {
        if (widget instanceof AbstractPrintWidgetText && field instanceof TextField) {
            AbstractPrintWidgetText widgetText = (AbstractPrintWidgetText)widget;
            widgetText.setOutputText((String)((TextField)field).getValue());
            return;
        }
        widget.setOutputValue(field);
    }

    private static Object runFormula(IWidgetExecuteHelper helper, IPrintWidget widget, String target) {
        if (target != null && (target.startsWith("=") || target.startsWith("$"))) {
            Object result = helper.runFormula(widget, target.substring(1));
            if (result instanceof Date) {
                InteTimeZone sysTz = InteTimeZone.getSysTimeZone();
                return sysTz.format((Date)result);
            }
            return result;
        }
        return null;
    }

    protected final void renameFileName() {
        if (CollectionUtils.isEmpty(this.runModelList) || ExecuteContext.get().isFileCreateBySingleBill()) {
            return;
        }
        RuntimeModel model = this.runModelList.get(0);
        List<Object> list = model.getFileName();
        String formId = model.getFormId();
        if (StringUtils.isEmpty((String)formId)) {
            this.fileName = model.getPdfName();
        } else {
            this.executeHelper = new ExecuteHelper(model);
            ((ExecuteHelper)this.executeHelper).setDelayVarProvider(this.delayVarProvider);
            IWidgetExecuteHelper.IDataHelper helper = this.executeHelper.getDataHelper();
            this.fileName = PrtFileNameUtil.parseFieldAndString(list, helper, model.getFormId());
        }
    }
}

