/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.execute.exporter.R1PrintW2VExporter;
import kd.bos.print.core.model.ui.component.Canvas;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.PWCellPainter;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.session.SystemPropertyUtils;

public abstract class AR1PNode_W2V {
    private IPrintWidget _node;
    private R1PrintW2VExporter _exporter;

    public void setExporter(R1PrintW2VExporter exporter) {
        this._exporter = exporter;
    }

    protected R1PrintW2VExporter getExporter() {
        return this._exporter;
    }

    public void setNode(IPrintWidget node) {
        this._node = node;
    }

    protected IPrintWidget getNode() {
        return this._node;
    }

    public IPainter exporting() {
        IPainter view = this.createViewt(this.getNode());
        this.exportCommon(this.getNode(), view);
        this.exportSpecial(this.getNode(), view);
        return view;
    }

    private void exportCommon(IPrintWidget widget, IPainter view) {
        Rectangle rect = widget.getRectangle();
        if (rect != null) {
            view.setPainterBounds((float)KPrintUtil.lomToPrintPoint(rect.x), (float)KPrintUtil.lomToPrintPoint(rect.y), (float)KPrintUtil.lomToPrintPoint(rect.width) + 1.0f, (float)KPrintUtil.lomToPrintPoint(rect.height) + 1.0f);
        }
        view.setStyle(StyleAccess.getStyle(widget));
    }

    protected void exportChildren(IPrintWidgetContainer widgetContainer, Canvas viewContainer) {
        if (widgetContainer.hasChildren()) {
            for (IPrintWidget widget : widgetContainer.getChildren()) {
                if (!widget.isPrintable()) continue;
                String isFastPicture = SystemPropertyUtils.getProptyByTenant((String)"PRT_FAST_MODEL_PIC", (String)RequestContext.get().getTenantId());
                if (!("false".equals(isFastPicture) || "xls".equals(ExecuteContext.get().getExpType()) || "png".equals(ExecuteContext.get().getExpType()) || "clientpreview".equals(ExecuteContext.get().getExpType()) || !(widget instanceof PWPicture) && !PWidgetUtil.isQRCode(widget))) {
                    PWCellPainter pwCellPainter = new PWCellPainter((AbstractPrintWidget)widget);
                    pwCellPainter.setContext(this.getExporter().getBasePainter().getPaintContext());
                    pwCellPainter.setPaintPaperInfo(this.getExporter().getBasePainter().getPaperInfo());
                    viewContainer.addPainter(pwCellPainter);
                    continue;
                }
                IPainter child = this.getExporter().translate(widget);
                child.setId(widget.getId());
                viewContainer.addPainter(child);
            }
        }
    }

    protected abstract IPainter createViewt(IPrintWidget var1);

    protected abstract void exportSpecial(IPrintWidget var1, IPainter var2);

    protected void updateChildLocation(int addedX, int addedY, IPainter cellView) {
        if (cellView instanceof Canvas) {
            Canvas cellCanvas = (Canvas)cellView;
            Map<Integer, Object> childrenMap = cellCanvas.getChildrenMap();
            if (childrenMap == null || childrenMap.isEmpty()) {
                return;
            }
            for (Map.Entry<Integer, Object> entry : childrenMap.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof List)) continue;
                List children = (List)value;
                for (Object child : children) {
                    if (!(child instanceof PWCellPainter)) continue;
                    PWCellPainter pwCellPainter = (PWCellPainter)child;
                    pwCellPainter.setParentX(addedX);
                    pwCellPainter.setParentY(addedY);
                }
            }
        }
    }

    protected void updateChildLocationByFunction(IPainter cellView, Function<AbstractPrintWidget, Point> correctPoint) {
        if (cellView instanceof Canvas) {
            Canvas cellCanvas = (Canvas)cellView;
            Map<Integer, Object> childrenMap = cellCanvas.getChildrenMap();
            if (childrenMap == null || childrenMap.isEmpty()) {
                return;
            }
            for (Map.Entry<Integer, Object> entry : childrenMap.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof List)) continue;
                List children = (List)value;
                for (Object child : children) {
                    if (child instanceof Canvas) {
                        Canvas childCanVas = (Canvas)child;
                        this.updateChildLocationByFunction(childCanVas, correctPoint);
                    }
                    if (!(child instanceof PWCellPainter)) continue;
                    PWCellPainter pwCellPainter = (PWCellPainter)child;
                    pwCellPainter.setCorrectPoint(correctPoint);
                }
            }
        }
    }
}

