/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ExportObjectFactory {
    private static Log log = LogFactory.getLog(ExportObjectFactory.class);
    private static final String NODE = "Node";
    private static final String TYPE = "type";
    private static final String CLASS = "class";
    private Map _classCache = new HashMap(16);

    public ExportObjectFactory(InputStream in) {
        SAXReader _sb = new SAXReader();
        Document doc = null;
        try {
            doc = _sb.read(in);
        }
        catch (Exception e) {
            log.error("parse config file faild");
        }
        if (doc != null) {
            Element root = doc.getRootElement();
            List child = root.elements(NODE);
            for (Element element : child) {
                String key = element.attributeValue(TYPE);
                String value = element.attributeValue(CLASS);
                this._classCache.put(key, value);
            }
        }
    }

    public Object newObject(String key) {
        String cls = (String)this._classCache.get(key);
        return this.createObject(cls);
    }

    private Object createObject(String cls) {
        Object obj = null;
        try {
            Class<?> c = Class.forName(cls);
            obj = c.newInstance();
        }
        catch (Exception e) {
            log.error("Can't create Instance of " + cls, (Throwable)e);
        }
        return obj;
    }
}

