/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.exception.ExportException;
import kd.bos.print.core.execute.exporter.AR1PNode_W2V;
import kd.bos.print.core.execute.exporter.ExportObjectFactory;
import kd.bos.print.core.execute.render.painter.BasePainter;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.widget.IPrintWidget;

public class R1PrintW2VExporter {
    private ExportObjectFactory _objFactory;
    private static final Log log = LogFactory.getLog(R1PrintW2VExporter.class);
    private BasePainter basePainter;
    private HashMap _cacheFactory = new HashMap();

    public R1PrintW2VExporter setPaperPainter(BasePainter basePainter) {
        this.basePainter = basePainter;
        return this;
    }

    public BasePainter getBasePainter() {
        return this.basePainter;
    }

    public R1PrintW2VExporter() throws ExportException {
        String config = "/PrtWidget2View.xml";
        try (InputStream in = this.getClass().getResourceAsStream(config);){
            if (in == null) {
                throw new ExportException("ObjectFactory config xml not found:" + config);
            }
            this._objFactory = new ExportObjectFactory(in);
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
    }

    private AR1PNode_W2V getTranslater(IPrintWidget node) {
        String key = node.getType();
        Object objNodeTranslater = this._cacheFactory.get(key);
        if (objNodeTranslater == null) {
            objNodeTranslater = this._objFactory.newObject(key);
            this._cacheFactory.put(key, objNodeTranslater);
        }
        return (AR1PNode_W2V)objNodeTranslater;
    }

    public IPainter translate(IPrintWidget widget) {
        AR1PNode_W2V translater = this.getTranslater(widget);
        if (translater == null) {
            return null;
        }
        translater.setExporter(this);
        translater.setNode(widget);
        return translater.exporting();
    }
}

