/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.impl;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.reportone.r1.print.common.ImageUtil;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.execute.exporter.AR1PNode_W2V;
import kd.bos.print.core.model.ui.component.BarCodeCell;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.barcode.PWBarcode;

public class R1PBarcode_W2V
extends AR1PNode_W2V {
    private static final Log log = LogFactory.getLog(R1PBarcode_W2V.class);

    @Override
    protected IPainter createViewt(IPrintWidget node) {
        return new BarCodeCell();
    }

    @Override
    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        PWBarcode pwBarcode = (PWBarcode)widget;
        BarCodeCell barcodeCell = (BarCodeCell)view;
        Field outputValue = pwBarcode.getOutputValue();
        if (outputValue != null && StringUtils.isNotBlank(outputValue.getValue())) {
            barcodeCell.setConfig((Map)outputValue.getValue());
        }
    }

    public static Image loadImage(Object value) {
        if (value != null) {
            byte[] imageData = null;
            if (value instanceof byte[]) {
                imageData = (byte[])value;
            } else if (value instanceof Blob) {
                imageData = R1PBarcode_W2V.blobToBytes((Blob)value);
            } else if (value instanceof String && value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
                imageData = ImageUtil.getImageByUrl((String)value);
            }
            if (imageData != null) {
                return ImageUtil.makeImage(imageData);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] blobToBytes(Blob blob) {
        ByteArrayOutputStream baos = null;
        try (InputStream is = blob.getBinaryStream();){
            if (is != null) {
                baos = new ByteArrayOutputStream();
                byte[] c = new byte[1024];
                int len = 0;
                while ((len = is.read(c, 0, c.length)) != -1) {
                    baos.write(c, 0, len);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }
        catch (Exception sqlEx) {
            log.error((Throwable)sqlEx);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return new byte[0];
    }
}

