/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.execute.exporter.AR1PNode_W2V;
import kd.bos.print.core.execute.exporter.impl.ContainerNode_W2V;
import kd.bos.print.core.execute.exporter.impl.StringNode_W2V;
import kd.bos.print.core.model.ui.component.Canvas;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.R1PLabelCell;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridColumn;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;

public class R1PDataGrid_W2V
extends AR1PNode_W2V {
    @Override
    protected IPainter createViewt(IPrintWidget node) {
        return new Canvas();
    }

    @Override
    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        StringNode_W2V cell_string_W2V = new StringNode_W2V();
        cell_string_W2V.setExporter(this.getExporter());
        ContainerNode_W2V cell_container_W2V = new ContainerNode_W2V();
        cell_container_W2V.setExporter(this.getExporter());
        PWDataGrid dataGrid = (PWDataGrid)widget;
        int sink = dataGrid.getExtProps().getInt("sinkToBottom", -1);
        Canvas canvas = (Canvas)view;
        int addedX = 0;
        int addedY = 0;
        int addedCellY = 0;
        int rc = dataGrid.getOutputRows().size();
        for (int r = 0; r < rc; ++r) {
            List cols;
            int i;
            ArrayList<Object> subCols;
            int columnCount;
            PWDataGrid subDataGrid;
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)dataGrid.getOutputRows().get(r);
            if (sink > 0 && row.getExtProps().getBoolean("sinkToBottom", false)) {
                addedY += sink;
                sink = -1;
            }
            if (row.isSubRow()) {
                subDataGrid = dataGrid.getSubDataGrids().get(0);
                columnCount = subDataGrid.getColumnCount();
                subCols = new ArrayList(10);
                for (i = 0; i < columnCount; ++i) {
                    subCols.add(subDataGrid.getColumn(i));
                }
                cols = subCols;
            } else {
                cols = dataGrid.getOutputColumns();
            }
            if (dataGrid.getSubDataGrids() != null && !dataGrid.getSubDataGrids().isEmpty() && "right".equals((subDataGrid = dataGrid.getSubDataGrids().get(0)).getSubGridDirection())) {
                columnCount = subDataGrid.getColumnCount();
                subCols = new ArrayList(10);
                for (int j = 0; j < dataGrid.getOutputColumns().size(); ++j) {
                    subCols.add(dataGrid.getOutputColumn(j));
                }
                for (i = 0; i < columnCount; ++i) {
                    subCols.add(subDataGrid.getColumn(i));
                }
                cols = subCols;
            }
            addedX = 0;
            int addedMaxCellY = 0;
            int cc = cols.size();
            for (int c = 0; c < cc; ++c) {
                PWDataGridColumn col = (PWDataGridColumn)cols.get(c);
                PWDataGridCell cell = (PWDataGridCell)row.getCell(c);
                if (cell != null && col.isPrintable()) {
                    IPainter cellView;
                    R1PDataGrid_W2V.dealStyle(dataGrid, row, col, cell, r, c);
                    if (cell.hasChildren()) {
                        cell_container_W2V.setNode(cell);
                        cellView = cell_container_W2V.exporting();
                    } else {
                        cell_string_W2V.setNode(cell);
                        cellView = cell_string_W2V.exporting();
                        if (cellView instanceof R1PLabelCell) {
                            ((R1PLabelCell)cellView).setCurrencyColumnSupport(cell.getExtProps().getBoolean("currencyColumn", true));
                        }
                    }
                    if (cell.isSubCell() && (cell.getCellValue() instanceof CellValueText || cell.getCellValue() instanceof CellValueField)) {
                        this.updateChildLocation(this.getNode().getRectangle().x + addedX, this.getNode().getRectangle().y + addedCellY, cellView);
                        cellView.setPainterLocation((float)KPrintUtil.lomToPrintPoint(addedX), (float)KPrintUtil.lomToPrintPoint(addedCellY));
                        addedMaxCellY = addedMaxCellY == 0 ? Math.max(addedMaxCellY, cell.getRectangle().height) : Math.min(addedMaxCellY, cell.getRectangle().height);
                    } else {
                        this.updateChildLocation(this.getNode().getRectangle().x + addedX, this.getNode().getRectangle().y + addedY, cellView);
                        cellView.setPainterLocation((float)KPrintUtil.lomToPrintPoint(addedX), (float)KPrintUtil.lomToPrintPoint(addedY));
                    }
                    canvas.addPainter(cellView);
                }
                if (!col.isPrintable()) continue;
                addedX += col.getWidth();
            }
            addedY += row.getHeight();
            addedCellY += addedMaxCellY;
        }
        canvas.setPainterSize((float)KPrintUtil.lomToPrintPoint(addedX) + 1.0f, (float)KPrintUtil.lomToPrintPoint(addedY) + 1.0f);
    }

    private static void dealStyle(PWDataGrid dataGrid, AbstractPWDataGridRow currentRow, PWDataGridColumn currentCol, PWDataGridCell currentCell, int rowIdx, int colIdx) {
        boolean isLastAtRow = true;
        int c = dataGrid.getOutputColumns().size();
        for (int j = colIdx + 1; j < c; ++j) {
            if (currentRow.getCell(j) == null || !((PWDataGridColumn)dataGrid.getOutputColumn(j)).isPrintable()) continue;
            isLastAtRow = false;
            break;
        }
        int rowBorderTag = colIdx == 0 ? (isLastAtRow ? 4369 : 4881) : (isLastAtRow ? 12561 : 13073);
        boolean isLastAtCol = true;
        int c2 = dataGrid.getOutputRows().size();
        for (int j = rowIdx + 1; j < c2; ++j) {
            if (((AbstractPWDataGridRow)dataGrid.getOutputRow(j)).getCell(colIdx) == null) continue;
            isLastAtCol = false;
            break;
        }
        int colBorderTag = rowIdx == 0 ? (isLastAtCol ? 4369 : 4371) : (isLastAtCol ? 4401 : 4403);
        StyleAccess styleAccess = currentCell.getStyleAccess();
        styleAccess.merge(currentRow.getStyleAccess(), rowBorderTag);
        styleAccess.merge(currentCol.getStyleAccess(), colBorderTag);
        styleAccess.merge(dataGrid.getStyleAccess(), colBorderTag | rowBorderTag);
    }
}

