/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.impl;

import java.awt.Point;
import java.util.Iterator;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.ImageUtil;
import kd.bos.print.core.execute.exporter.AR1PNode_W2V;
import kd.bos.print.core.model.ui.component.Canvas;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.ImageCell;
import kd.bos.print.core.model.ui.component.Page;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.headfooter.PWHeadFooter;

public class R1PPage_W2V
extends AR1PNode_W2V {
    private StyleAttributes _backgroundSa;

    @Override
    public IPainter exporting() {
        PWPage widgetPage = (PWPage)this.getNode();
        PWHeadFooter widgetHeader = null;
        PWHeadFooter widgetFooter = null;
        Iterator it = widgetPage.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof PWHeadFooter)) continue;
            if (((PWHeadFooter)child).getId() == "headerOfLongPageMode") {
                widgetHeader = (PWHeadFooter)child;
                it.remove();
                continue;
            }
            if (((PWHeadFooter)child).getId() != "footerOfLongPageMode") continue;
            widgetFooter = (PWHeadFooter)child;
            it.remove();
        }
        IPainter page = super.exporting();
        if (widgetHeader != null && widgetFooter != null) {
            Canvas header = new Canvas();
            header.setPainterSize(page.getWidth(), (float)KPrintUtil.lomToPrintPoint(widgetHeader.getRectangle().height));
            this.exportChildren(widgetHeader, header);
            Canvas footer = new Canvas();
            footer.setPainterSize(page.getWidth(), (float)KPrintUtil.lomToPrintPoint(widgetFooter.getRectangle().height));
            this.exportChildren(widgetFooter, footer);
            Page bigPage = new Page();
            bigPage.addPainter(header);
            bigPage.addPainter(page);
            bigPage.addPainter(footer);
            float y = 0.0f;
            header.setPainterLocation(0.0f, y);
            page.setPainterLocation(0.0f, y += header.getHeight());
            footer.setPainterLocation(0.0f, y += page.getHeight());
            double height = (double)y + (double)footer.getHeight();
            bigPage.setPainterSize(page.getWidth(), (float)height);
            return bigPage;
        }
        return page;
    }

    @Override
    protected IPainter createViewt(IPrintWidget node) {
        return new Page();
    }

    @Override
    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        PWPage widgetPage = (PWPage)widget;
        Page printPage = (Page)view;
        byte[] background = widgetPage.getBackgroundPicture();
        if (background != null) {
            ImageCell imageCell = new ImageCell();
            imageCell.setImage(ImageUtil.makeImage(background));
            imageCell.setLayer(1);
            imageCell.setStyle(Styles.getStyle(this.getBackgroundSa()));
            Point offset = widgetPage.getBackgroundOffset();
            float x = (float)KPrintUtil.lomToPrintPoint(offset.x);
            float y = (float)KPrintUtil.lomToPrintPoint(offset.y);
            float width = printPage.getWidth();
            float height = printPage.getHeight();
            imageCell.setPainterBounds(x, y, width - x, height - y);
            printPage.addPainter(imageCell);
        }
        this.exportChildren(widgetPage, printPage);
    }

    private StyleAttributes getBackgroundSa() {
        if (this._backgroundSa == null) {
            this._backgroundSa = Styles.getDefaultSA();
            this._backgroundSa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            this._backgroundSa.setVerticalAlign(Styles.VerticalAlignment.TOP);
        }
        return this._backgroundSa;
    }
}

