/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.impl;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.ImageUtil;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.execute.exporter.AR1PNode_W2V;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.ImageCell;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWPicture;

public class R1PPicture_W2V
extends AR1PNode_W2V {
    private static final Log log = LogFactory.getLog(R1PPicture_W2V.class);

    @Override
    protected IPainter createViewt(IPrintWidget node) {
        return new ImageCell();
    }

    @Override
    public IPainter exporting() {
        PWPicture widgetPicture = (PWPicture)this.getNode();
        Field outputValue = widgetPicture.getOutputValue();
        if (outputValue instanceof ImageField && !StringUtil.isEmptyString((String)((ImageField)outputValue).getValue())) {
            byte[] imageByte = ((ImageField)outputValue).getImageByte();
            if (widgetPicture.isAdjustHeight()) {
                if (imageByte == null) {
                    imageByte = ImageUtil.getImageByUrl((String)((ImageField)outputValue).getValue());
                }
                if (imageByte != null) {
                    Image image = ImageUtil.makeImage(imageByte);
                    Rectangle rectangle = widgetPicture.getRectangle();
                    Number[] size = ImageUtil.calcImageSize(StyleUtil.pixelToLom(image.getWidth(null)), StyleUtil.pixelToLom(image.getHeight(null)), rectangle.width, rectangle.height);
                    widgetPicture.setRectangle(new Rectangle(rectangle.x, rectangle.y, size[0].intValue(), size[1].intValue()));
                }
            }
        }
        return super.exporting();
    }

    @Override
    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        PWPicture widgetPicture = (PWPicture)widget;
        ImageCell imageCell = (ImageCell)view;
        imageCell.setScale(widgetPicture.getScaleType());
        Field outputValue = widgetPicture.getOutputValue();
        if (outputValue == null) {
            return;
        }
        if (outputValue instanceof ImageField) {
            imageCell.setImageKey((String)((ImageField)outputValue).getValue());
            byte[] imageByte = ((ImageField)outputValue).getImageByte();
            if (imageByte != null) {
                imageCell.setImage(R1PPicture_W2V.loadImage(imageByte));
            }
        } else {
            imageCell.setImage(R1PPicture_W2V.loadImage(outputValue.getValue()));
        }
    }

    public static Image loadImage(Object value) {
        if (value != null) {
            byte[] imageData = null;
            if (value instanceof byte[]) {
                imageData = (byte[])value;
            } else if (value instanceof Blob) {
                imageData = R1PPicture_W2V.blobToBytes((Blob)value);
            } else if (value instanceof String && StringUtils.isNotBlank((Object)value)) {
                imageData = ImageUtil.getImageByUrl((String)value);
            }
            if (imageData != null) {
                return ImageUtil.makeImage(imageData);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] blobToBytes(Blob blob) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             InputStream is = blob.getBinaryStream();){
            if (is == null) return new byte[0];
            byte[] c = new byte[1024];
            int len = 0;
            while ((len = is.read(c, 0, c.length)) != -1) {
                baos.write(c, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (SQLException sqlEx) {
            log.error((Throwable)sqlEx);
            return new byte[0];
        }
        catch (IOException ioEx) {
            log.error((Throwable)ioEx);
        }
        return new byte[0];
    }
}

