/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.exporter.impl;

import java.awt.Rectangle;
import kd.bos.print.core.ctrl.reportone.r1.print.common.IAdjustHeightRenderSupport;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.execute.exporter.AR1PNode_W2V;
import kd.bos.print.core.execute.exporter.R1PrintW2VExporter;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;
import kd.bos.print.core.execute.render.painter.BasePainter;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.model.ui.component.IPainter;
import kd.bos.print.core.model.ui.component.R1PLabelCell;
import kd.bos.print.core.model.ui.component.VariantLabelCell;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.model.widget.runner.util.AdjustHeightUtil;
import kd.bos.util.StringUtils;

class StringNode_W2V
extends AR1PNode_W2V {
    StringNode_W2V() {
    }

    @Override
    protected IPainter createViewt(IPrintWidget node) {
        AbstractPrintWidgetText widgetText = (AbstractPrintWidgetText)node;
        String text = widgetText.getOutputText();
        if (text != null && text.startsWith("&[") && text.endsWith("]")) {
            VariantLabelCell vlc = new VariantLabelCell();
            vlc.setText(text);
            return vlc;
        }
        return new R1PLabelCell();
    }

    @Override
    protected void exportSpecial(IPrintWidget widget, IPainter view) {
        if (view instanceof R1PLabelCell) {
            Field outputValue;
            AbstractPrintWidgetText widgetText = (AbstractPrintWidgetText)widget;
            R1PLabelCell labelCell = (R1PLabelCell)view;
            String outputText = widgetText.getOutputText();
            if (StringUtils.isBlank((String)outputText) && (outputValue = widgetText.getOutputValue()) != null) {
                TextRunner runner = (TextRunner)widgetText.getRunner();
                outputText = runner.formatOutputValue(outputValue).toString();
            }
            labelCell.setText(outputText);
            labelCell.setDivideCharNums(widgetText.getDivideCharNums());
            labelCell.setDivideModel(widgetText.getDivideModel());
            if (widgetText instanceof PWText) {
                PWText pwText = (PWText)widgetText;
                labelCell.setTextHeight(pwText.getTextHeight());
                Rectangle rect = pwText.getRectangle();
                if (rect != null) {
                    labelCell.setLineWrapParam(new LineWrapParam.Builder(pwText.getOutputText(), LineWrapRule.getRule(pwText.getLineWrapRule())).style(StyleAccess.getStyle(pwText)).wordFlex(pwText.isWordFlex()).minW(rect.width).maxW(Math.max(rect.width, this.getPageWidth())).minH(rect.height).maxH(pwText.getContainerHeight()).build());
                    labelCell.setFlexOffset(pwText.getFlexOffset());
                }
            }
            if (widget instanceof IAdjustHeightRenderSupport) {
                boolean useAdjustHeightRender = ((IAdjustHeightRenderSupport)((Object)widget)).isUseAdjustHeightRender();
                if (useAdjustHeightRender && DelayVarProvider.isBindDelayVar(widget)) {
                    Rectangle rectangle = widget.getRectangle();
                    int height = (int)rectangle.getHeight();
                    int width = (int)rectangle.getWidth();
                    AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(new LineWrapParam.Builder(outputText, ((IAdjustHeightRenderSupport)((Object)widget)).getLineWrapRule()).style(StyleAccess.getStyle(widget)).minW(width).maxW(Math.max(width, this.getPageWidth())).minH(height).maxH(height).build());
                    labelCell.setTextHeight(adjustInfo.getTextHeight());
                    labelCell.setText(adjustInfo.getUsedText());
                }
                labelCell.setUseAdjustHeightRender(useAdjustHeightRender);
            }
            if (widgetText instanceof PWText) {
                PWText text = (PWText)widgetText;
                labelCell.setCurrencyColumnSupport("Amount".equals(text.getTextFormat()));
                labelCell.setAnchor(text.isAnchor());
                labelCell.setLinkUrl(text.getLinkUrl());
            }
        }
    }

    private int getPageWidth() {
        R1PrintInfo printInfo;
        PaintPaperInfo paperInfo;
        BasePainter basePainter;
        R1PrintW2VExporter exporter = this.getExporter();
        if (exporter != null && (basePainter = exporter.getBasePainter()) != null && (paperInfo = basePainter.getPaperInfo()) != null && (printInfo = paperInfo.getR1PrintInfo()) != null) {
            return (int)(printInfo.getPaperSize().getWidth() - (double)printInfo.getMarginLeft() - (double)printInfo.getMarginRight());
        }
        return 0;
    }
}

