/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.helper;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.data.DataUsingContext;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.execute.RuntimeModel;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.script.ScriptExecutor;

public class ExecuteHelper
implements IWidgetExecuteHelper {
    private static final Log log = LogFactory.getLog(ExecuteHelper.class);
    private RuntimeModel runtimeModel;
    private IWidgetExecuteHelper.IDataHelper dataHelper = new DataHelper();
    private DelayVarProvider delayVarProvider;
    private DataUsingContext dataUsingContext = new DataUsingContext();

    public ExecuteHelper(RuntimeModel runtimeModel) {
        this.runtimeModel = runtimeModel;
    }

    public RuntimeModel getRuntimeModel() {
        return this.runtimeModel;
    }

    public void setRuntimeModel(RuntimeModel runtimeModel) {
        this.runtimeModel = runtimeModel;
    }

    @Override
    public IWidgetExecuteHelper.IDataHelper getDataHelper() {
        return this.dataHelper;
    }

    @Override
    public void setDataHelper(IWidgetExecuteHelper.IDataHelper dataHelper) {
        this.dataHelper = dataHelper;
    }

    @Override
    public void markOutputId(IPrintWidget widget) {
    }

    @Override
    public Object runFormula(IPrintWidget widget, String formula) {
        try {
            ScriptExecutor executor = new ScriptExecutor();
            String result = executor.execute(formula, widget);
            if (StringUtils.isBlank((CharSequence)result)) {
                return null;
            }
            if (!DelayVarProvider.isVar(result) && DelayVarProvider.isContainsVar(result)) {
                result = DelayVarProvider.makeVarSign(result);
            }
            return result;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    @Override
    public DelayVarProvider getDelayVarProvider() {
        if (this.delayVarProvider == null) {
            // empty if block
        }
        return this.delayVarProvider;
    }

    public void setDelayVarProvider(DelayVarProvider dvp) {
        this.delayVarProvider = dvp;
    }

    @Override
    public DataUsingContext getDataContext() {
        return this.dataUsingContext;
    }

    private class DataHelper
    implements IWidgetExecuteHelper.IDataHelper {
        private DataHelper() {
        }

        @Override
        public R1PDataVisitor getDataVisitor(String ds) {
            return ExecuteHelper.this.runtimeModel.getDataVisitor(ds);
        }

        @Override
        public int getRowsCount(String ds) {
            return ExecuteHelper.this.runtimeModel.getDataVisitor(ds).getRowsCount();
        }

        @Override
        public boolean isContextRelative() {
            return false;
        }

        @Override
        public Field getFieldValue(String ds, String field) {
            R1PDataVisitor dataVisitor = ExecuteHelper.this.runtimeModel.getDataVisitor(ds);
            if (dataVisitor == null) {
                return NullField.get();
            }
            Field fieldValue = dataVisitor.getField(ds, field);
            return fieldValue;
        }

        @Override
        public byte[] getImageByte(String imageKey) {
            try {
                if (StringUtils.isBlank((CharSequence)imageKey)) {
                    return null;
                }
                return ExecuteHelper.this.runtimeModel.getImageByte(imageKey);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return null;
            }
        }
    }
}

