/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.importer;

import java.awt.Rectangle;
import java.util.List;
import kd.bos.print.core.execute.importer.R1PrintD2WImporter;
import kd.bos.print.core.model.designer.common.IContainer;
import kd.bos.print.core.model.designer.common.IElement;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IFxSupport;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PrintAtPage;

public abstract class AR1PNode_D2W {
    private IReportObject node;
    private R1PrintD2WImporter importer;

    protected R1PrintD2WImporter getImporter() {
        return this.importer;
    }

    public void setImporter(R1PrintD2WImporter importer) {
        this.importer = importer;
    }

    private IReportObject getNode() {
        return this.node;
    }

    public void setNode(IReportObject node) {
        this.node = node;
    }

    public IPrintWidget importing() {
        IPrintWidget widget = this.createWidget(this.getNode());
        AR1PNode_D2W.importCommon(this.getNode(), widget);
        this.importSpecial(this.getNode(), widget);
        return widget;
    }

    private static void importCommon(IReportObject design, IPrintWidget widget) {
        AR1PNode_D2W.importElementCommon(design, widget);
        widget.setType(design.getType());
        Rectangle rect = new Rectangle(design.getXLom(), design.getYLom(), design.getWidthLom(), design.getHeightLom());
        widget.setRectangle(rect);
        widget.setHFill(design.isHorizontalFill());
        widget.setVFill(design.isVerticalFill());
        if (widget instanceof AbstractPrintWidget) {
            AbstractPrintWidget printWidget = (AbstractPrintWidget)widget;
            printWidget.setPrintAtPage(PrintAtPage.from(design.getPrintAtPage()));
        }
        if (widget instanceof IFxSupport && design instanceof IFxSupport) {
            IFxSupport fxSupport = (IFxSupport)((Object)widget);
            List<Object> formulaData = ((IFxSupport)((Object)design)).getFormulaData();
            fxSupport.setFormulaData(formulaData);
        }
    }

    protected static void importElementCommon(IElement design, IPrintWidget widget) {
        widget.setId(design.getId());
        widget.setKey(design.getKey());
        widget.setStyle(design.getStyle());
        widget.setPreScript(design.getPreScript());
        widget.setScript(design.getScript());
        widget.setPrintable(!design.isHide());
        widget.setHideMove(design.isHideMove());
    }

    protected void importChildren(IContainer designContainer, IPrintWidgetContainer widgetContainer) {
        if (designContainer.getChildrenCount() > 0) {
            for (IReportObject ro : designContainer.getChildren()) {
                IPrintWidget child = this.getImporter().translate(ro);
                widgetContainer.addChild(child);
            }
        }
    }

    protected abstract IPrintWidget createWidget(IReportObject var1);

    protected abstract void importSpecial(IReportObject var1, IPrintWidget var2);
}

