/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.importer.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.execute.importer.AR1PNode_D2W;
import kd.bos.print.core.execute.importer.impl.R1PText_D2W;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.designer.grid.AbstractColumn;
import kd.bos.print.core.model.designer.grid.AbstractRow;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.designer.grid.datagrid.DataGrid;
import kd.bos.print.core.model.designer.grid.datagrid.DataGridCell;
import kd.bos.print.core.model.designer.grid.datagrid.DataGridDetailRow;
import kd.bos.print.core.model.designer.grid.datagrid.DataGridGroupRow;
import kd.bos.print.core.model.designer.grid.datagrid.DataGridNormalRow;
import kd.bos.print.core.model.designer.grid.datagrid.R1PrintGroup;
import kd.bos.print.core.model.designer.grid.tabletail.TableTail;
import kd.bos.print.core.model.widget.AbstractPrintWidgetField;
import kd.bos.print.core.model.widget.IFxSupport;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.GroupDesc;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridColumn;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWGroupRow;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;

public class R1PDataGrid_D2W
extends AR1PNode_D2W {
    private static final String STAT_SUM = "sum";
    private static final String STAT_PAGE_SUM = "pageSum";
    private static final String STAT_GROUP_SUM = "groupSum";
    private static final String STAT_AVG = "avg";
    private static final String STAT_MAX = "max";
    private static final String STAT_MIN = "min";
    private static final String STAT_COUNT = "count";
    private static final String MERGE_PREFIX = "MERGE_PREFIX_";
    public static final String MAINGRID_SEQ = "MAINGRID_seq";
    private static Log log = LogFactory.getLog(R1PDataGrid_D2W.class);

    public static String getMergeHeadField(String field) {
        return MERGE_PREFIX + field;
    }

    @Override
    protected IPrintWidget createWidget(IReportObject node) {
        return new PWDataGrid();
    }

    @Override
    protected void importSpecial(IReportObject design, IPrintWidget widget) {
        TableTail tableTail;
        DataGrid designGrid = (DataGrid)design;
        PWDataGrid widgetGrid = (PWDataGrid)widget;
        widgetGrid.setDatasource(designGrid.getDatasource());
        widgetGrid.setFixedRowAtPage(designGrid.isFixedRowAtPage());
        widgetGrid.setFixedRowCount(designGrid.getFixedRowCount());
        widgetGrid.setTitleRowEveryPage(designGrid.isNormalRowEveryPage());
        widgetGrid.setStatRowEveryPage(designGrid.isStatRowEveryPage());
        widgetGrid.setNotBlankRow(designGrid.isNotBlankRow());
        widgetGrid.setGridBorderType(designGrid.getBorderType());
        widgetGrid.setWholeRowPage(designGrid.isWholeRowPage());
        widgetGrid.setWholeGridPage(designGrid.isWholeGridPage());
        if (widgetGrid.isWholeGridPage()) {
            widgetGrid.setTempWholeRowPage(true);
        }
        widgetGrid.setStatWithData(designGrid.isStatWithData());
        widgetGrid.setHideEmptyMove(designGrid.isHideEmptyMove());
        int lc = designGrid.getColumnsCount();
        for (int j = 0; j < lc; ++j) {
            AbstractColumn designCol = designGrid.getColumn(j);
            PWDataGridColumn widgetCol = widgetGrid.addColumn();
            R1PDataGrid_D2W.importElementCommon(designCol, widgetCol);
            widgetCol.setWidth(designCol.getWidthLom());
        }
        boolean hSubGrid = false;
        if (designGrid.isWholeGridPage()) {
            DataGrid subGrid = null;
            if (designGrid.getSubDataGrids() != null && !designGrid.getSubDataGrids().isEmpty() && "right".equals((subGrid = designGrid.getSubDataGrids().get(0)).getSubGridDirection())) {
                hSubGrid = true;
                widgetGrid.setSubGridDs(subGrid.getDatasource());
                int lc2 = subGrid.getColumnsCount();
                for (int j = 0; j < lc2; ++j) {
                    AbstractColumn designCol = subGrid.getColumn(j);
                    PWDataGridColumn widgetCol = widgetGrid.addColumn();
                    R1PDataGrid_D2W.importElementCommon(designCol, widgetCol);
                    widgetCol.setWidth(designCol.getWidthLom());
                }
                this.importRow(designGrid, widgetGrid, subGrid);
            } else {
                this.importRow(designGrid, widgetGrid, null);
            }
        } else {
            this.importRow(designGrid, widgetGrid, null);
        }
        Map<String, MergeBlock> mergeBlocks = widgetGrid.getMergeBlocks();
        mergeBlocks.putAll(designGrid.getMergeBlocks());
        for (Map.Entry<String, MergeBlock> entry : mergeBlocks.entrySet()) {
            MergeBlock block = entry.getValue();
            int columnStart = block.getLeft();
            int colunmEnd = block.getRight();
            int rowStart = block.getTop();
            int rowEnd = block.getBottom();
            for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
                for (int colIndex = columnStart; colIndex <= colunmEnd; ++colIndex) {
                    PWDataGridCell cell = (PWDataGridCell)((AbstractPWDataGridRow)widgetGrid.getRow(rowIndex)).getCell(colIndex);
                    if (rowIndex == rowStart && colIndex == columnStart) {
                        cell.setMergeType(MergeType.Merged);
                    } else {
                        cell.setMergeType(MergeType.BeMerged);
                        cell.setStyle(((PWDataGridCell)((AbstractPWDataGridRow)widgetGrid.getRow(rowStart)).getCell(columnStart)).getStyle());
                        cell.setCellValue(new CellValueText(""));
                    }
                    cell.setMergeBlock(block);
                }
            }
        }
        if (!hSubGrid) {
            this.importSubGrid(designGrid, widgetGrid);
        }
        if ((tableTail = designGrid.getTableTail()) != null) {
            IPrintWidget pwTableTail = this.getImporter().translate(tableTail);
            widgetGrid.setTableTail((PWTableTail)pwTableTail);
        }
    }

    private void importRow(DataGrid designGrid, PWDataGrid widgetGrid, DataGrid subGrid) {
        if (subGrid != null) {
            List[][] gridArr = new List[][]{{new ArrayList(4), new ArrayList(4)}, {new ArrayList(4), new ArrayList(4)}, {new ArrayList(4), new ArrayList(4)}};
            this.setGridArr(designGrid, gridArr, 0);
            this.setGridArr(subGrid, gridArr, 1);
            List gridNormalRows = gridArr[0][0];
            List subGridNormalRows = gridArr[0][1];
            this.mergeSubGridNormalRow(designGrid, widgetGrid, gridNormalRows, subGridNormalRows);
            List gridDetailRows = gridArr[1][0];
            List subGridDetailRows = gridArr[1][1];
            if (gridDetailRows.size() > 0 && subGridDetailRows.size() > 0) {
                AbstractRow designRow = (AbstractRow)gridDetailRows.get(0);
                AbstractRow subDesignRow = (AbstractRow)subGridDetailRows.get(0);
                AbstractPWDataGridRow widgetRow = this.createRow(designGrid, widgetGrid, designRow, 0);
                for (int i = 0; i < designRow.getCellCount(); ++i) {
                    PWDataGridCell cell = (PWDataGridCell)widgetRow.getCell(i);
                    if (cell == null) continue;
                    cell.setMergeBy(true);
                    ACellValue cellValue = cell.getCellValue();
                    if (!(cellValue instanceof CellValueField) || !"seq".equals(((CellValueField)cellValue).getField())) continue;
                    CellValueField cellValueField = (CellValueField)cellValue;
                    cellValueField.setField(MAINGRID_SEQ);
                    cell.setBindField(MAINGRID_SEQ);
                }
                this.importCell(designGrid, subDesignRow, widgetRow, designGrid.getColumnsCount(), widgetGrid.getDatasource());
            }
            List gridStatRows = gridArr[2][0];
            List subGridStatRows = gridArr[2][1];
            this.mergeSubGridNormalRow(designGrid, widgetGrid, gridStatRows, subGridStatRows);
        } else {
            int rc = designGrid.getRowsCount();
            for (int i = 0; i < rc; ++i) {
                AbstractRow designRow = designGrid.getRow(i);
                this.createRow(designGrid, widgetGrid, designRow);
            }
        }
    }

    private void mergeSubGridNormalRow(DataGrid designGrid, PWDataGrid widgetGrid, List<AbstractRow> gridNormalRows, List<AbstractRow> subGridNormalRows) {
        int subRowSize;
        int rowSize = gridNormalRows.size();
        if (rowSize == (subRowSize = subGridNormalRows.size())) {
            for (int i = 0; i < rowSize; ++i) {
                AbstractRow designRow = gridNormalRows.get(i);
                AbstractRow subDesignRow = subGridNormalRows.get(i);
                AbstractPWDataGridRow widgetRow = this.createRow(designGrid, widgetGrid, designRow, 0);
                this.importCell(designGrid, subDesignRow, widgetRow, designGrid.getColumnsCount(), widgetGrid.getDatasource());
            }
        } else if (rowSize > subRowSize) {
            int top = 0;
            int bottom = 0;
            for (int i = 0; i < rowSize; ++i) {
                AbstractRow designRow = gridNormalRows.get(i);
                if (i <= subRowSize - 1) {
                    AbstractRow subDesignRow = subGridNormalRows.get(i);
                    AbstractPWDataGridRow widgetRow = this.createRow(designGrid, widgetGrid, designRow, 0);
                    this.importCell(designGrid, subDesignRow, widgetRow, designGrid.getColumnsCount(), widgetGrid.getDatasource());
                    top = widgetRow.getRowIndex();
                    continue;
                }
                AbstractPWDataGridRow widgetRow = this.createRow(designGrid, widgetGrid, designRow, 0);
                this.importEmptyCell((DataGridCell)designRow.getCell(0), widgetRow, designGrid.getColumnsCount(), widgetGrid.getColumnCount());
                bottom = widgetRow.getRowIndex();
                if (subRowSize != 0 || i != 0) continue;
                top = widgetRow.getRowIndex();
            }
            MergeBlock mergeBlock = MergeBlock.create(designGrid.getColumnsCount(), widgetGrid.getColumnCount() - 1, top, bottom);
            this.setCellMergeInfo(widgetGrid, mergeBlock);
        } else {
            int top = 0;
            int bottom = 0;
            for (int i = 0; i < subRowSize; ++i) {
                AbstractRow subDesignRow = subGridNormalRows.get(i);
                if (i <= rowSize - 1) {
                    AbstractRow designRow = gridNormalRows.get(i);
                    AbstractPWDataGridRow widgetRow = this.createRow(designGrid, widgetGrid, designRow, 0);
                    this.importCell(designGrid, subDesignRow, widgetRow, designGrid.getColumnsCount(), widgetGrid.getDatasource());
                    top = widgetRow.getRowIndex();
                    continue;
                }
                AbstractPWDataGridRow widgetRow = this.createRow(designGrid, widgetGrid, subDesignRow, designGrid.getColumnsCount());
                this.importEmptyCell((DataGridCell)subDesignRow.getCell(0), widgetRow, 0, designGrid.getColumnsCount());
                bottom = widgetRow.getRowIndex();
                if (rowSize != 0 || i != 0) continue;
                top = widgetRow.getRowIndex();
            }
            MergeBlock mergeBlock = MergeBlock.create(0, designGrid.getColumnsCount() - 1, top, bottom);
            this.setCellMergeInfo(widgetGrid, mergeBlock);
        }
    }

    private void setCellMergeInfo(PWDataGrid widgetGrid, MergeBlock mergeBlock) {
        int columnStart = mergeBlock.getLeft();
        int columnEnd = mergeBlock.getRight();
        int rowStart = mergeBlock.getTop();
        int rowEnd = mergeBlock.getBottom();
        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
            for (int colIndex = columnStart; colIndex <= columnEnd; ++colIndex) {
                PWDataGridCell cell;
                AbstractPWDataGridRow row = (AbstractPWDataGridRow)widgetGrid.getRow(rowIndex);
                if (row == null || (cell = (PWDataGridCell)row.getCell(colIndex)) == null) continue;
                if (rowIndex == rowStart) {
                    cell.setMergeType(MergeType.Merged);
                } else {
                    cell.setMergeType(MergeType.BeMerged);
                }
                MergeBlock clone = (MergeBlock)mergeBlock.clone();
                clone.setLeft(colIndex);
                clone.setRight(colIndex);
                cell.setMergeBlock(clone);
            }
        }
    }

    private void setGridArr(DataGrid designGrid, List[][] gridArr, int gridType) {
        for (int i = 0; i < designGrid.getRowsCount(); ++i) {
            AbstractRow row = designGrid.getRow(i);
            if (row instanceof DataGridNormalRow) {
                DataGridNormalRow normalRow = (DataGridNormalRow)row;
                if (normalRow.isStatRow()) {
                    gridArr[2][gridType].add(normalRow);
                    continue;
                }
                gridArr[0][gridType].add(normalRow);
                continue;
            }
            if (!(row instanceof DataGridDetailRow)) continue;
            gridArr[1][gridType].add(row);
        }
    }

    private AbstractPWDataGridRow createRow(DataGrid designGrid, PWDataGrid widgetGrid, AbstractRow designRow, int startIndex) {
        AbstractPWDataGridRow widgetRow;
        if (designRow instanceof DataGridNormalRow) {
            boolean isStatRow = ((DataGridNormalRow)designRow).isStatRow();
            if (isStatRow) {
                widgetRow = widgetGrid.addRow(3);
            } else {
                widgetRow = widgetGrid.addRow(1);
                widgetRow.setDisplayEveryPage(widgetGrid.isTitleRowEveryPage());
            }
        } else if (designRow instanceof DataGridDetailRow) {
            widgetRow = widgetGrid.addRow(2);
            PWDetailRow detailRow = (PWDetailRow)widgetRow;
            detailRow.setMergeByField(((DataGridDetailRow)designRow).getMergeByField());
            detailRow.setMergeSummaryField(((DataGridDetailRow)designRow).getMergeSummaryField());
        } else {
            widgetRow = widgetGrid.addRow(4);
            PWGroupRow groupRow = (PWGroupRow)widgetRow;
            String groupField = null;
            boolean isDividePageWhenDifferentGroup = false;
            R1PrintGroup group = (R1PrintGroup)((DataGridGroupRow)designRow).getGroup();
            if (group != null) {
                groupField = group.getAccording();
                isDividePageWhenDifferentGroup = group.isDividePageWhenDifferGroup();
            }
            GroupDesc groupDesc = new GroupDesc();
            groupDesc.setGroupField(groupField);
            groupDesc.setDividePageWhenDifferent(isDividePageWhenDifferentGroup);
            groupRow.setGroupDesc(groupDesc);
        }
        R1PDataGrid_D2W.importElementCommon(designRow, widgetRow);
        widgetRow.setHeight(designRow.getHeightLom());
        if (designGrid.isAutoAdjustHeight()) {
            widgetRow.setAdjustHeight(Boolean.TRUE);
        }
        this.importCell(designGrid, designRow, widgetRow, startIndex, null);
        return widgetRow;
    }

    private AbstractPWDataGridRow createRow(DataGrid designGrid, PWDataGrid widgetGrid, AbstractRow designRow) {
        return this.createRow(designGrid, widgetGrid, designRow, 0);
    }

    private void importSubGrid(DataGrid designContainer, PWDataGrid pwDataGrid) {
        List<DataGrid> subDataGrids = designContainer.getSubDataGrids();
        if (subDataGrids == null || subDataGrids.isEmpty()) {
            return;
        }
        ArrayList<PWDataGrid> subPWDataGrids = new ArrayList<PWDataGrid>(subDataGrids.size());
        for (DataGrid subDataGrid : subDataGrids) {
            PWDataGrid child = (PWDataGrid)this.getImporter().translate(subDataGrid);
            child.setSubGridDirection(subDataGrid.getSubGridDirection());
            child.setSubGrid(subDataGrid.isSubGrid());
            subPWDataGrids.add(child);
        }
        pwDataGrid.setSubDataGrids(subPWDataGrids);
    }

    private void importCell(DataGrid dataGrid, AbstractRow designRow, AbstractPWDataGridRow widgetRow, int startIndex, String specifyDs) {
        int j = 0;
        int lc = designRow.getCellCount();
        while (j < lc) {
            DataGridCell designCell = (DataGridCell)designRow.getCell(j);
            if (StringUtils.isBlank((CharSequence)designCell.getDatasource())) {
                specifyDs = null;
            }
            PWDataGridCell widgetCell = (PWDataGridCell)widgetRow.getCell(startIndex);
            String statType = designCell.getStatType();
            R1PDataGrid_D2W.importElementCommon(designCell, widgetCell);
            widgetCell.setMergeSummary(designCell.isMergeSummary());
            String ds = designCell.getDatasource();
            widgetCell.setDatasource(ds);
            widgetCell.setBindField(designCell.getBindField());
            R1PText_D2W.dTextProp2W(widgetCell, designCell);
            if (widgetCell.isAdjustHeight()) {
                widgetRow.setAdjustHeight(Boolean.TRUE);
            }
            widgetCell.setAnchor(designCell.isAnchor());
            widgetCell.setLinkUrl(designCell.getLinkUrl());
            widgetCell.setLinkDs(designCell.getLinkDs());
            widgetCell.setLinkDsType(designCell.getLinkDsType());
            widgetCell.setLinkField(designCell.getLinkFiled());
            if (designCell.getChildren() != null && designCell.getChildren().size() > 0) {
                this.importChildren(designCell, widgetCell);
            } else {
                String datasource = specifyDs;
                if (StringUtils.isBlank((CharSequence)datasource)) {
                    datasource = designCell.getDatasource();
                }
                widgetCell.setDatasource(datasource);
                if (StringUtils.isNotBlank((CharSequence)datasource)) {
                    if (StringUtils.isNotBlank((CharSequence)statType)) {
                        CellValueStat cellValue = new CellValueStat(designCell.getBindField());
                        widgetCell.setCellValue(cellValue);
                        if (dataGrid.isSubGrid()) {
                            cellValue.setStatType(1);
                        } else {
                            cellValue.setStatType(R1PDataGrid_D2W.loadStatType(statType));
                        }
                        if (cellValue.getStatType() == 6) {
                            widgetRow.setDisplayEveryPage(Boolean.TRUE);
                        }
                    } else {
                        widgetCell.setCellValue(new CellValueField(designCell.getBindField()));
                    }
                } else {
                    widgetCell.setCellValue(new CellValueText(designCell.getBindField()));
                }
            }
            if (((Set)ExecuteContext.get().getHasMergePrintDsMap().getOrDefault(ExecuteContext.get().getTplKey(), new HashSet(0))).contains(dataGrid.getDatasource()) && designRow instanceof DataGridDetailRow) {
                R1PDataGrid_D2W.mergePrintChangeCellDataSource((PWDetailRow)widgetRow, dataGrid.getDatasource(), widgetCell);
            }
            ++j;
            ++startIndex;
        }
    }

    private void importEmptyCell(DataGridCell designCell, AbstractPWDataGridRow widgetRow, int startIndex, int endIndex) {
        for (int j = startIndex; j < endIndex; ++j) {
            PWDataGridCell widgetCell = (PWDataGridCell)widgetRow.getCell(j);
            R1PDataGrid_D2W.importElementCommon(designCell, widgetCell);
            R1PText_D2W.dTextProp2W(widgetCell, designCell);
        }
    }

    static void mergePrintChangeCellDataSource(PWDetailRow detailRow, String gridDataSource, AbstractPWGridCell widgetCell) {
        if (widgetCell.getChildren() != null && widgetCell.getChildren().size() > 0) {
            List<IPrintWidget> widgetCellChildren = widgetCell.getChildren();
            for (int index = 0; index < widgetCellChildren.size(); ++index) {
                IPrintWidget child = widgetCellChildren.get(index);
                if (!(child instanceof AbstractPrintWidgetField)) continue;
                AbstractPrintWidgetField datasourceSupport = (AbstractPrintWidgetField)child;
                if (R1PDataGrid_D2W.checkIsMainDataSource(datasourceSupport.getDatasource())) {
                    datasourceSupport.setDatasource(gridDataSource);
                    String bindField = datasourceSupport.getBindField();
                    if (StringUtils.isNotBlank((CharSequence)bindField)) {
                        String mergeHeadField = R1PDataGrid_D2W.getMergeHeadField(bindField);
                        datasourceSupport.setBindField(mergeHeadField);
                        R1PDataGrid_D2W.setNewMergeByField(detailRow, bindField, mergeHeadField);
                    }
                }
                ArrayList<Object> cellFormulaData = new ArrayList(0);
                if (datasourceSupport instanceof PWText) {
                    cellFormulaData = ((PWText)datasourceSupport).getFormulaData();
                } else if (datasourceSupport instanceof IFxSupport) {
                    cellFormulaData = ((IFxSupport)((Object)datasourceSupport)).getFormulaData();
                }
                R1PDataGrid_D2W.changeFormulaDataSource(gridDataSource, datasourceSupport.getDatasource(), cellFormulaData);
            }
        } else {
            String datasource = widgetCell.getDatasource();
            if (R1PDataGrid_D2W.checkIsMainDataSource(datasource)) {
                widgetCell.setDatasource(gridDataSource);
                String bindField = widgetCell.getBindField();
                if (StringUtils.isNotBlank((CharSequence)bindField)) {
                    String mergeHeadField = R1PDataGrid_D2W.getMergeHeadField(bindField);
                    widgetCell.setBindField(mergeHeadField);
                    widgetCell.setCellValue(new CellValueField(mergeHeadField));
                    R1PDataGrid_D2W.setNewMergeByField(detailRow, bindField, mergeHeadField);
                }
            }
            List<Object> cellFormulaData = widgetCell.getFormulaData();
            R1PDataGrid_D2W.changeFormulaDataSource(gridDataSource, datasource, cellFormulaData);
        }
    }

    private static void setNewMergeByField(PWDetailRow detailRow, String bindField, String mergeHeadField) {
        String mergeByField;
        if (detailRow != null && StringUtils.isNotBlank((CharSequence)(mergeByField = detailRow.getMergeByField())) && mergeByField.contains(bindField)) {
            String[] split = mergeByField.split(";");
            ArrayList<String> newMergeByFields = new ArrayList<String>(10);
            for (String field : split) {
                if (String.valueOf(field).equals(bindField)) {
                    newMergeByFields.add(mergeHeadField);
                    continue;
                }
                newMergeByFields.add(field);
            }
            String newMergeByField = StringUtils.join((Object[])newMergeByFields.toArray(), (String)";");
            detailRow.setMergeByField(newMergeByField);
        }
    }

    private static void changeFormulaDataSource(String gridDataSource, String datasource, List<Object> cellFormulaData) {
        if (StringUtils.isBlank((CharSequence)datasource) && !CollectionUtils.isEmpty(cellFormulaData)) {
            List<Object> formulaData = cellFormulaData;
            for (Object formulaDatum : formulaData) {
                Object bindField;
                Map formulaMap;
                String ds;
                if (!(formulaDatum instanceof Map) || !R1PDataGrid_D2W.checkIsMainDataSource(ds = (String)(formulaMap = (Map)formulaDatum).get("dataSource")) || !StringUtils.isNotBlank(bindField = formulaMap.get("bindField"))) continue;
                String mergeHeadField = R1PDataGrid_D2W.getMergeHeadField(String.valueOf(bindField));
                formulaMap.put("dataSource", gridDataSource);
                formulaMap.put("bindField", mergeHeadField);
            }
        }
    }

    private static boolean checkIsMainDataSource(String dataSource) {
        return StringUtils.isNotBlank((CharSequence)dataSource) && dataSource.equals(ExecuteContext.get().getFormId());
    }

    private static int loadStatType(String statType) {
        if (StringUtil.equalsIgnoreCase(STAT_SUM, statType)) {
            return 1;
        }
        if (StringUtil.equalsIgnoreCase(STAT_PAGE_SUM, statType)) {
            return 6;
        }
        if (StringUtil.equalsIgnoreCase(STAT_AVG, statType)) {
            return 2;
        }
        if (StringUtil.equalsIgnoreCase(STAT_MAX, statType)) {
            return 3;
        }
        if (StringUtil.equalsIgnoreCase(STAT_MIN, statType)) {
            return 4;
        }
        if (StringUtil.equalsIgnoreCase(STAT_COUNT, statType)) {
            return 5;
        }
        if (StringUtil.equalsIgnoreCase(STAT_GROUP_SUM, statType)) {
            return 18;
        }
        return 0;
    }
}

