/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.importer.impl;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.execute.importer.AR1PNode_D2W;
import kd.bos.print.core.execute.importer.impl.R1PText_D2W;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.designer.grid.AbstractColumn;
import kd.bos.print.core.model.designer.grid.AbstractRow;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.designer.grid.layoutgrid.LayoutGrid;
import kd.bos.print.core.model.designer.grid.layoutgrid.LayoutGridCell;
import kd.bos.print.core.model.widget.AbstractPrintWidgetField;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGrid;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGridCell;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGridColumn;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGridRow;

public class R1PLayoutGrid_D2W
extends AR1PNode_D2W {
    private static CellValueText emptyValueText = new CellValueText("");

    @Override
    protected IPrintWidget createWidget(IReportObject node) {
        return new PWLayoutGrid();
    }

    @Override
    protected void importSpecial(IReportObject design, IPrintWidget widget) {
        LayoutGrid designGrid = (LayoutGrid)design;
        PWLayoutGrid widgetGrid = (PWLayoutGrid)widget;
        widgetGrid.setGridBorderType(designGrid.getBorderType());
        widgetGrid.setWholeRowPage(designGrid.isWholeRowPage());
        widgetGrid.setWholeGridPage(designGrid.isWholeGridPage());
        if (widgetGrid.isWholeGridPage()) {
            widgetGrid.setTempWholeRowPage(true);
        }
        widgetGrid.setNotBlankRow(designGrid.isNotBlankRow());
        int lc = designGrid.getColumnsCount();
        for (int j = 0; j < lc; ++j) {
            AbstractColumn designCol = designGrid.getColumn(j);
            PWLayoutGridColumn widgetCol = widgetGrid.addColumn();
            R1PLayoutGrid_D2W.importElementCommon(designCol, widgetCol);
            widgetCol.setWidth(designCol.getWidthLom());
        }
        int rc = designGrid.getRowsCount();
        for (int i = 0; i < rc; ++i) {
            AbstractRow designRow = designGrid.getRow(i);
            Object widgetRow = widgetGrid.addRow(1);
            R1PLayoutGrid_D2W.importElementCommon(designRow, widgetRow);
            ((AbstractPWGridRow)widgetRow).setHeight(designRow.getHeightLom());
            ((AbstractPWGridRow)widgetRow).setAdjustHeight(designGrid.isAutoAdjustHeight());
            this.importCell(design, designRow, (AbstractPWGridRow)widgetRow);
        }
        Map<String, MergeBlock> mergeBlocks = widgetGrid.getMergeBlocks();
        mergeBlocks.putAll(designGrid.getMergeBlocks());
        for (Map.Entry<String, MergeBlock> entry : mergeBlocks.entrySet()) {
            MergeBlock block = entry.getValue();
            int columnStart = block.getLeft();
            int colunmEnd = block.getRight();
            int rowStart = block.getTop();
            int rowEnd = block.getBottom();
            for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
                for (int colIndex = columnStart; colIndex <= colunmEnd; ++colIndex) {
                    PWLayoutGridCell cell = (PWLayoutGridCell)((PWLayoutGridRow)widgetGrid.getRow(rowIndex)).getCell(colIndex);
                    if (rowIndex == rowStart && colIndex == columnStart) {
                        cell.setMergeType(MergeType.Merged);
                    } else {
                        cell.setMergeType(MergeType.BeMerged);
                        cell.setCellValue(emptyValueText);
                        cell.setStyle(((PWLayoutGridCell)((PWLayoutGridRow)widgetGrid.getRow(rowStart)).getCell(columnStart)).getStyle());
                    }
                    cell.setMergeBlock(block);
                }
            }
        }
    }

    private void importCell(IReportObject design, AbstractRow designRow, AbstractPWGridRow widgetRow) {
        int lc = designRow.getCellCount();
        for (int j = 0; j < lc; ++j) {
            LayoutGridCell designCell = (LayoutGridCell)designRow.getCell(j);
            Object widgetCell = widgetRow.getCell(j);
            R1PLayoutGrid_D2W.importElementCommon(designCell, widgetCell);
            String ds = designCell.getDatasource();
            ((AbstractPrintWidgetField)widgetCell).setDatasource(ds);
            ((AbstractPrintWidgetField)widgetCell).setBindField(designCell.getBindField());
            R1PText_D2W.dTextProp2W(widgetCell, designCell);
            if (((AbstractPrintWidgetText)widgetCell).isAdjustHeight()) {
                widgetRow.setAdjustHeight(true);
            }
            ((PWText)widgetCell).setAnchor(designCell.isAnchor());
            ((PWText)widgetCell).setLinkUrl(designCell.getLinkUrl());
            ((PWText)widgetCell).setLinkDs(designCell.getLinkDs());
            ((PWText)widgetCell).setLinkDsType(designCell.getLinkDsType());
            ((PWText)widgetCell).setLinkField(designCell.getLinkFiled());
            if (designCell.getChildren() != null && designCell.getChildren().size() > 0) {
                this.importChildren(designCell, (IPrintWidgetContainer)widgetCell);
            } else {
                String datasource = designCell.getDatasource();
                ((AbstractPrintWidgetField)widgetCell).setDatasource(datasource);
                if (StringUtils.isNotBlank((CharSequence)datasource)) {
                    ((AbstractPWGridCell)widgetCell).setCellValue(new CellValueField(designCell.getBindField()));
                } else {
                    ((AbstractPWGridCell)widgetCell).setCellValue(new CellValueText(designCell.getBindField()));
                }
            }
            this.mergePrintChangeCellDataSource(design, (AbstractPWGridCell)widgetCell);
        }
    }

    protected void mergePrintChangeCellDataSource(IReportObject design, AbstractPWGridCell widgetCell) {
    }
}

