/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.importer.impl;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.execute.importer.AR1PNode_D2W;
import kd.bos.print.core.model.IBindFieldSupport;
import kd.bos.print.core.model.designer.PictureObject;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWPicture;

public class R1PPicture_D2W
extends AR1PNode_D2W
implements IBindFieldSupport {
    private String datasource;
    private String bindField;

    @Override
    protected IPrintWidget createWidget(IReportObject node) {
        return new PWPicture();
    }

    @Override
    protected void importSpecial(IReportObject design, IPrintWidget widget) {
        PictureObject node = (PictureObject)design;
        PWPicture widgetPicture = (PWPicture)widget;
        String datasource = node.getDatasource();
        if (StringUtils.isNotBlank((CharSequence)datasource)) {
            widgetPicture.setDatasource(datasource);
            widgetPicture.setBindField(node.getBindField());
        } else if (node.isLinked()) {
            widgetPicture.setBindField(node.getImageExpression());
        } else if (node.getImageContent() != null) {
            widgetPicture.setOutputValue(new ImageField("", node.getImageContent()));
        } else {
            widgetPicture.setBindField(node.getBindField());
        }
        widgetPicture.setScaleType(node.getScale());
    }

    @Override
    public void setBindField(String bindField) {
        this.bindField = bindField;
    }

    @Override
    public String getBindField() {
        return this.bindField;
    }

    @Override
    public void setDatasource(String ds) {
        this.datasource = ds;
    }

    @Override
    public String getDatasource() {
        return this.datasource;
    }
}

