/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender;

import com.alibaba.druid.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.qrender.CPage;
import kd.bos.print.core.execute.qrender.CWaterMark;

public class CPaper
implements Serializable {
    private int x;
    private int y;
    private int w;
    private int h;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int ot;
    private String type = "CPaper";
    private String margin;
    private List<CPage> children;
    private String bgK;
    private String bg;
    private CWaterMark waterMark;

    public CPaper() {
    }

    public CPaper(R1PrintInfo r1PrintInfo) {
        Dimension paperSize = r1PrintInfo.getPaperSize();
        if (r1PrintInfo.getOrientation() == "LANDSCAPE") {
            this.setW(paperSize.height);
            this.setH(paperSize.width);
            this.setOt(1);
        } else {
            this.setW(paperSize.width);
            this.setH(paperSize.height);
        }
        int marginLeft = r1PrintInfo.getMarginLeft();
        int marginRight = r1PrintInfo.getMarginRight();
        int marginBottom = r1PrintInfo.getMarginBottom();
        int marginTop = r1PrintInfo.getMarginTop();
        StringBuilder builder = new StringBuilder();
        if (marginTop == marginBottom && marginLeft == marginRight && marginTop == marginLeft) {
            builder.append(marginTop);
        } else if (marginTop == marginBottom && marginLeft == marginRight) {
            builder.append(marginTop).append(";").append(marginLeft);
        } else {
            builder.append(marginTop).append(";").append(marginRight).append(";").append(marginBottom).append(";").append(marginLeft);
        }
        this.setMargin(builder.toString());
        if (r1PrintInfo.isShowBgImage()) {
            this.bgK = r1PrintInfo.getBgImageUrl();
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public String getType() {
        return this.type;
    }

    public String getMargin() {
        return this.margin;
    }

    public void setMargin(String margin) {
        this.margin = margin;
    }

    public List<CPage> getChildren() {
        return this.children;
    }

    public void setChildren(List<CPage> children) {
        this.children = children;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBgK() {
        return this.bgK;
    }

    public void setBgK(String bgK) {
        this.bgK = bgK;
    }

    public String getBg() {
        return this.bg;
    }

    public void setBg(String bg) {
        this.bg = bg;
    }

    public String toString() {
        String result = SerializationUtils.toJsonString((Object)this);
        return result;
    }

    public boolean equal(CPaper cPaper) {
        if (cPaper == null) {
            return false;
        }
        if (this.x != cPaper.getX() || this.y != cPaper.getY() || this.w != cPaper.getW() || this.h != cPaper.getH() || !StringUtils.equals((String)this.margin, (String)cPaper.getMargin())) {
            return false;
        }
        if (this.children.size() != cPaper.getChildren().size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i).equal(cPaper.getChildren().get(i))) continue;
            return false;
        }
        return true;
    }

    public CWaterMark getWaterMark() {
        return this.waterMark;
    }

    public void setWaterMark(CWaterMark waterMark) {
        this.waterMark = waterMark;
    }

    public int getOt() {
        return this.ot;
    }

    public void setOt(int ot) {
        this.ot = ot;
    }
}

