/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender;

import java.util.ArrayList;
import java.util.List;
import kd.bos.form.watermark.WaterMark;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.qrender.CPage;
import kd.bos.print.core.execute.qrender.CPaper;
import kd.bos.print.core.execute.qrender.CRenderUnit;
import kd.bos.print.core.execute.qrender.CStyle;
import kd.bos.print.core.execute.qrender.CWaterMark;
import kd.bos.print.core.execute.qrender.convert.CPageConvert;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.model.widget.PWPage;

public class CRenderUtil {
    private CPageConvert pageConvert;

    public CRenderUtil(CRenderUnit measureUnit, CRenderUnit fontUnit) {
        this.pageConvert = new CPageConvert(measureUnit, fontUnit);
    }

    public CRenderUtil() {
        this.pageConvert = new CPageConvert(CRenderUnit.UNIT_MM, CRenderUnit.UNIT_PIX);
    }

    public CPaper fromWidget(PaintPaperInfo paperInfo, List<PWPage> pwPages) {
        R1PrintInfo r1PrintInfo = paperInfo.getR1PrintInfo();
        CPaper cPaper = new CPaper(r1PrintInfo);
        cPaper.setWaterMark(this.parseWaterMark(paperInfo.getWaterMark()));
        ArrayList<CPage> cPages = new ArrayList<CPage>(pwPages.size());
        for (PWPage pwPage : pwPages) {
            CPage cPage = this.fromWidget(pwPage);
            cPages.add(cPage);
        }
        cPaper.setChildren(cPages);
        return cPaper;
    }

    public CWaterMark parseWaterMark(WaterMark waterMark) {
        CWaterMark cwaterMark = this.pageConvert.parseWaterMark(waterMark);
        return cwaterMark;
    }

    public CPage fromWidget(PWPage pwPage) {
        CPage cPage = this.pageConvert.parseFormWidget(pwPage);
        return cPage;
    }

    public CStyle fromPWStyle(Style style) {
        return this.pageConvert.fromPWStyle(style);
    }
}

