/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kd.bos.entity.param.CustomParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.qrender.CJob;
import kd.bos.print.core.execute.qrender.CPaper;
import kd.bos.print.core.execute.qrender.CRenderUnit;
import kd.bos.print.core.execute.qrender.CRenderUtil;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.PaperPainter;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.service.IClientService;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.lang.StringUtils;

public class ClientCaptain
extends RenderCaptain<PaperPainter> {
    private Log log = LogFactory.getLog(ClientCaptain.class);
    protected int maxPageSize = 50;
    private int minPageSize = 20;
    private int maxIdeTime = 30000;
    private long lastConsumeTime = 0L;
    protected String taskName;
    private List<PaperPainter> painterList = new ArrayList<PaperPainter>(10);
    protected CRenderUtil renderUtil = new CRenderUtil(CRenderUnit.UNIT_MM, CRenderUnit.UNIT_PT);
    protected int seq = 0;

    public ClientCaptain(ExecuteLife executeLife) {
        super(executeLife);
        this.initCalParam();
    }

    protected void initCalParam() {
        IClientService clientService = ExecuteContext.get().getServiceProxy().getClientService();
        this.maxPageSize = clientService.getMaxPageSize();
        this.minPageSize = clientService.getMinPageSize();
        this.maxIdeTime = clientService.getMaxIdeTime();
        Map customParam = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        String minPageSizeP = (String)customParam.get("ClientCaptain_MinPageSize");
        String maxPageSizeP = (String)customParam.get("ClientCaptain_MaxPageSize");
        String maxIdeTimeP = (String)customParam.get("ClientCaptain_MaxIdeTime");
        if (StringUtils.isNotBlank((String)minPageSizeP)) {
            this.minPageSize = Integer.parseInt(minPageSizeP);
        }
        if (StringUtils.isNotBlank((String)maxPageSizeP)) {
            this.maxPageSize = Integer.parseInt(maxPageSizeP);
        }
        if (StringUtils.isNotBlank((String)maxIdeTimeP)) {
            this.maxIdeTime = Integer.parseInt(maxIdeTimeP);
        }
    }

    private int getMaxPageSize() {
        int copyNum = ExecuteContext.get().getServiceProxy().getClientService().getCopyNum();
        if (copyNum != 1) {
            return ExecuteContext.get().getPageLimit();
        }
        return this.maxPageSize;
    }

    @Override
    public void put(PaperPainter paper) throws InterruptedException {
        if (StringUtils.isBlank((String)this.taskName)) {
            this.lastConsumeTime = System.currentTimeMillis();
            this.taskName = paper.getTplName();
        }
        if (this.painterList.size() >= this.getMaxPageSize()) {
            this.consumePainter(false);
        } else if (System.currentTimeMillis() - this.lastConsumeTime >= (long)this.maxIdeTime) {
            this.log.debug("\u4efb\u52a1{}\uff0c\u8d85\u8fc7\u6700\u5927\u7b49\u5f85\u65f6\u95f4\uff0c\u53d1\u9001\u6570\u636e\u5305\uff0c\u6570\u636e\u5305\u5927\u5c0f\u4e3a\uff1a{}", (Object)this.painterList.size());
            this.consumePainter(false);
        }
        this.painterList.add(paper);
    }

    @Override
    public void endWork() throws ExecutionException, InterruptedException {
    }

    public void finishOne(boolean isLast) {
        if (isLast && ExecuteContext.get().isLastRunModel()) {
            this.consumePainter(true);
        } else if (this.painterList.size() >= this.minPageSize) {
            this.consumePainter(false);
        }
    }

    @Deprecated
    public void finishOne() {
        this.finishOne(false);
    }

    @Override
    public void finish() {
        this.consumePainter(true);
        PrtAttach prtAttach = new PrtAttach();
        prtAttach.setTaskId(ExecuteContext.get().getTaskId());
        prtAttach.setOrgId(ExecuteService.getUserService().getOrgId());
        prtAttach.setAppId(ExecuteContext.get().getAppId());
        prtAttach.setUserId(ExecuteService.getUserId());
        prtAttach.setFormId(ExecuteContext.get().getFormId());
        prtAttach.setDiskType(ExecuteContext.get().getpFileStorageType().getCode());
        prtAttach.setExtType(ExecuteContext.get().getExpType());
        prtAttach.setTaskName(this.taskName);
        prtAttach.setStatus("A");
        IClientService clientService = ExecuteContext.get().getServiceProxy().getClientService();
        clientService.savePrtResult(prtAttach);
    }

    protected void consumePainter(boolean isEnd) {
        this.lastConsumeTime = System.currentTimeMillis();
        ArrayList<PWPage> pages = new ArrayList<PWPage>(10);
        if (this.painterList.isEmpty()) {
            return;
        }
        for (PaperPainter paperPainter : this.painterList) {
            pages.add((PWPage)paperPainter.getPaintObj());
        }
        this.executePaper(this.painterList.get(0).getPaperInfo(), pages, isEnd);
        pages.clear();
        this.painterList.clear();
    }

    private void executePaper(PaintPaperInfo paperInfo, List<PWPage> pwPages, boolean isEnd) {
        CPaper cPaper = this.renderUtil.fromWidget(paperInfo, pwPages);
        CJob<CPaper> cJob = new CJob<CPaper>();
        cJob.setTaskId(ExecuteContext.get().getTaskId());
        if (this.seq == 0) {
            cJob.setTaskName(this.taskName);
            cJob.setJobName(paperInfo.getTplName());
        } else {
            cJob.setJobName(paperInfo.getTplName() + "-" + this.seq);
        }
        cJob.setInfo(cPaper);
        cJob.setSeq(this.seq);
        cJob.setEnd(isEnd);
        ExecuteContext.get().getServiceProxy().getClientService().execute(cJob);
        if (this.seq == 2) {
            this.minPageSize *= 10;
            this.maxPageSize *= 10;
        }
        ++this.seq;
    }
}

