/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.CustomParam;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.qrender.CGrid;
import kd.bos.print.core.execute.qrender.CGridRow;
import kd.bos.print.core.execute.qrender.CJob;
import kd.bos.print.core.execute.qrender.CLabel;
import kd.bos.print.core.execute.qrender.CPage;
import kd.bos.print.core.execute.qrender.CPanel;
import kd.bos.print.core.execute.qrender.CPaper;
import kd.bos.print.core.execute.qrender.CRender;
import kd.bos.print.core.execute.qrender.CWaterMark;
import kd.bos.print.core.execute.qrender.ClientCaptain;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.PaperPainter;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.service.IClientService;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.lang.StringUtils;

public class ClientTotalPageCaptain
extends ClientCaptain {
    private List<CPage> cPageList = new ArrayList<CPage>(10);
    private PaintPaperInfo paperInfo;
    private int pageSize;
    private int maxMemoryPageSize = 100000;

    public ClientTotalPageCaptain(ExecuteLife executeLife) {
        super(executeLife);
    }

    @Override
    protected void initCalParam() {
        IClientService clientService = ExecuteContext.get().getServiceProxy().getClientService();
        this.maxPageSize = clientService.getMaxPageSize();
        Map customParam = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        String maxPageSizeP = (String)customParam.get("ClientCaptain_MaxPageSize");
        String maxMemoryPageSize = (String)customParam.get("ClientCaptain_MaxMemoryPageSize");
        if (StringUtils.isNotBlank((String)maxPageSizeP)) {
            this.maxPageSize = Integer.parseInt(maxPageSizeP);
        }
        if (StringUtils.isNotBlank((String)maxMemoryPageSize)) {
            this.maxMemoryPageSize = Integer.parseInt(maxMemoryPageSize);
        }
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void put(PaperPainter paper) throws InterruptedException {
        if (this.pageSize > this.maxMemoryPageSize) {
            String message = ResManager.loadKDString((String)"\u6309\u6240\u9009\u5355\u636e\u751f\u6210\u603b\u9875\u7801\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927%s\u9875\u3002", (String)"ClientTotalPageCaptain_0", (String)"bos-print-core", (Object[])new Object[0]);
            throw new PrintException("-1", message);
        }
        ++this.pageSize;
        if (StringUtils.isBlank((String)this.taskName)) {
            this.taskName = paper.getTplName();
            this.paperInfo = paper.getPaperInfo();
        }
        CPage cPage = this.renderUtil.fromWidget((PWPage)paper.getPaintObj());
        this.cPageList.add(cPage);
    }

    @Override
    protected void consumePainter(boolean isEnd) {
        ArrayList<CPage> handList = new ArrayList<CPage>(10);
        Iterator<CPage> iterator = this.cPageList.iterator();
        while (iterator.hasNext()) {
            CPage cPage = iterator.next();
            this.handPageLabel(cPage.getChildren(), cLabel -> {
                String outputText = ClientTotalPageCaptain.handPageTotalVarText(cLabel.getText(), this.pageSize);
                cLabel.setText(outputText);
            });
            if (handList.size() < this.maxPageSize - 1 && iterator.hasNext()) {
                handList.add(cPage);
            } else {
                handList.add(cPage);
                this.executePaper(this.paperInfo, handList, !iterator.hasNext());
                handList.clear();
            }
            iterator.remove();
        }
    }

    @Override
    public void finishOne(boolean isLast) {
    }

    private void executePaper(PaintPaperInfo paperInfo, List<CPage> cPages, boolean isEnd) {
        if (cPages == null || cPages.isEmpty()) {
            return;
        }
        R1PrintInfo r1PrintInfo = paperInfo.getR1PrintInfo();
        CPaper cPaper = new CPaper(r1PrintInfo);
        cPaper.setChildren(cPages);
        CWaterMark waterMark = this.renderUtil.parseWaterMark(paperInfo.getWaterMark());
        cPaper.setWaterMark(waterMark);
        CJob<CPaper> cJob = new CJob<CPaper>();
        cJob.setTaskId(ExecuteContext.get().getTaskId());
        if (this.seq == 0) {
            cJob.setTaskName(this.taskName);
            cJob.setJobName(paperInfo.getTplName());
        } else {
            cJob.setJobName(paperInfo.getTplName() + "-" + this.seq);
        }
        cJob.setInfo(cPaper);
        cJob.setSeq(this.seq);
        cJob.setEnd(isEnd);
        ExecuteContext.get().getServiceProxy().getClientService().execute(cJob);
        if (this.seq == 2) {
            this.maxPageSize *= 10;
        }
        ++this.seq;
    }

    private <T extends CRender> void handPageLabel(List<T> children, Consumer<CLabel> consumer) {
        for (CRender cRender : children) {
            if (cRender instanceof CLabel) {
                CLabel cLabel = (CLabel)cRender;
                if (!ClientTotalPageCaptain.isTotalCLabel(cLabel)) continue;
                consumer.accept(cLabel);
                continue;
            }
            if (cRender instanceof CPanel) {
                List<CRender> innerChildren = ((CPanel)cRender).getChildren();
                this.handPageLabel(innerChildren, consumer);
                continue;
            }
            if (!(cRender instanceof CGrid)) continue;
            List<CGridRow> cGridRows = ((CGrid)cRender).getChildren();
            for (CGridRow gridRow : cGridRows) {
                List<CLabel> innerChildren = gridRow.getChildren();
                this.handPageLabel(innerChildren, consumer);
            }
        }
    }

    private static boolean isTotalCLabel(CLabel cLabel) {
        String text = cLabel.getText();
        if (StringUtils.isBlank((String)text)) {
            return false;
        }
        return text.startsWith("&[") && text.endsWith("]") && text.contains("&[pageTotal]");
    }

    private static String handPageTotalVarText(String var, int pageTotal) {
        if ((var = var.replace("&[pageTotal]", String.valueOf(pageTotal))).startsWith("&[") && var.endsWith("]")) {
            var = var.substring(2, var.length() - 1);
        }
        return var;
    }
}

