/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender.convert;

import java.awt.Color;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.ctrl.kdf.util.style.Border;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.execute.qrender.CBase;
import kd.bos.print.core.execute.qrender.CRenderUnit;
import kd.bos.print.core.execute.qrender.CStyle;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.service.PrtFont;

public abstract class AbstractRenderConvert<T extends AbstractPrintWidget, P extends CBase> {
    protected CRenderUnit measureUnit = CRenderUnit.UNIT_MM;
    protected CRenderUnit fontUnit = CRenderUnit.UNIT_PIX;

    protected abstract P parseFormWidget(T var1);

    protected abstract T parseFromRender(P var1);

    protected float getFontSize(float fontPixSize) {
        if (this.fontUnit == CRenderUnit.UNIT_PT) {
            return fontPixSize * 72.0f / (float)KDToolkit.getCurrentDpi();
        }
        return fontPixSize;
    }

    public String parseBorder(Style pwStyle) {
        StringBuilder builder = new StringBuilder();
        Border pwBorder = pwStyle.getBorder(Styles.Position.TOP);
        this.parseSingleBorder(pwBorder, builder);
        String borderT = builder.toString();
        builder.setLength(0);
        pwBorder = pwStyle.getBorder(Styles.Position.RIGHT);
        this.parseSingleBorder(pwBorder, builder);
        String borderR = builder.toString();
        builder.setLength(0);
        pwBorder = pwStyle.getBorder(Styles.Position.BOTTOM);
        this.parseSingleBorder(pwBorder, builder);
        String borderB = builder.toString();
        pwBorder = pwStyle.getBorder(Styles.Position.LEFT);
        builder.setLength(0);
        this.parseSingleBorder(pwBorder, builder);
        String borderL = builder.toString();
        builder.setLength(0);
        if (StringUtils.equals((CharSequence)borderT, (CharSequence)borderR) && StringUtils.equals((CharSequence)borderT, (CharSequence)borderB) && StringUtils.equals((CharSequence)borderT, (CharSequence)borderL)) {
            if (StringUtils.isBlank((CharSequence)borderT)) {
                return null;
            }
            builder.append(borderT);
        } else if (StringUtils.equals((CharSequence)borderT, (CharSequence)borderB) && StringUtils.equals((CharSequence)borderR, (CharSequence)borderL)) {
            builder.append(borderT).append(";").append(borderR);
        } else {
            builder.append(borderT).append(";").append(borderR).append(";").append(borderB).append(";").append(borderL);
        }
        return builder.toString();
    }

    protected void parseSingleBorder(Border pwBorder, StringBuilder builder) {
        if (!pwBorder.isNull()) {
            builder.append(this.colorToHex(pwBorder.getColor())).append("_").append(pwBorder.getPenStyle().getName()).append("_").append(this.getLineWidth(pwBorder));
        } else {
            builder.append(" ");
        }
    }

    public CStyle fromPWStyle(Style pwStyle) {
        CStyle style = new CStyle();
        ExecuteContext.get().getServiceProxy().getFontService().getFonts();
        style.setFontSize(this.getFontSize(pwStyle.getFontSizeF()));
        String fontName = pwStyle.getFontName();
        List<PrtFont> fonts = ExecuteService.getFontService().getFonts();
        Optional<PrtFont> option = fonts.stream().filter(prtFont -> StringUtils.equals((CharSequence)prtFont.getFontName(), (CharSequence)fontName)).findAny();
        if (option.isPresent()) {
            style.setFontName(ExecuteService.getDefaultFont().getFontName());
        } else {
            style.setFontName(fontName);
        }
        style.setFontName(fontName);
        Color background = pwStyle.getBackground();
        style.setBgColor(this.colorToHex(background));
        style.setFontColor(this.colorToHex(pwStyle.getFontColor()));
        style.setBold(pwStyle.isBold());
        style.setItalic(pwStyle.isItalic());
        style.setUnderline(pwStyle.isUnderline());
        style.setStrike(pwStyle.isStrikeThrough());
        style.setLsT(pwStyle.getLineSpacingType());
        if ((double)style.getLsT() == 1.0) {
            style.setLs(pwStyle.getLineSpaceB());
        } else {
            style.setLs(pwStyle.getLinespacing());
        }
        StringBuilder builder = new StringBuilder();
        builder.append(pwStyle.getHorizontalAlign().getValue()).append(";").append(pwStyle.getVerticalAlign().getValue());
        style.setAlign(builder.toString());
        Rect padding = pwStyle.getPadding();
        builder.setLength(0);
        if (padding.getTop() == padding.getRight() && padding.getTop() == padding.getBottom() && padding.getTop() == padding.getLeft()) {
            builder.append(padding.getTop());
        } else if (padding.getTop() == padding.getBottom() && padding.getLeft() == padding.getRight()) {
            builder.append(padding.getTop()).append(";").append(padding.getLeft());
        } else {
            builder.append(padding.getTop()).append(";").append(padding.getRight()).append(";").append(padding.getBottom()).append(";").append(padding.getLeft());
        }
        style.setPadding(builder.toString());
        style.setBorder(this.parseBorder(pwStyle));
        return style;
    }

    private float getLineWidth(Border pwBorder) {
        LineStyle lineStyle = pwBorder.getLineStyle();
        if (lineStyle == LineStyle.SINGLE_LINE_HALF) {
            return 0.5f;
        }
        return pwBorder.getLineStyle().getWidth();
    }

    protected String colorToHex(Color color) {
        StringBuilder sb = new StringBuilder("#");
        String str = Integer.toHexString(color.getRed());
        if (str.length() < 2) {
            sb.append("0");
        }
        sb.append(str);
        str = Integer.toHexString(color.getGreen());
        if (str.length() < 2) {
            sb.append("0");
        }
        sb.append(str);
        str = Integer.toHexString(color.getBlue());
        if (str.length() < 2) {
            sb.append("0");
        }
        sb.append(str);
        return sb.toString();
    }
}

