/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender.convert;

import java.awt.Rectangle;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.execute.qrender.CBarCode;
import kd.bos.print.core.execute.qrender.convert.CPageConvert;
import kd.bos.print.core.execute.qrender.convert.CRenderConvert;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.barcode.painter.EAN128Utils;

public class CBarcodeConvert
extends CRenderConvert<PWBarcode, CBarCode> {
    public CBarcodeConvert(CPageConvert pageConvert) {
        super(pageConvert);
    }

    @Override
    protected CBarCode createCRender() {
        return new CBarCode();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CBarCode parseFormWidget(PWBarcode pwBarcode) {
        void var8_12;
        void var8_10;
        CBarCode cBarCode = this.createCRender();
        super.fillBaseProperty(pwBarcode, cBarCode);
        BarcodeObject barcodeObject = pwBarcode.getBarcodeObject();
        Rectangle rectangle = pwBarcode.getRectangle();
        Field outputValue = pwBarcode.getOutputValue();
        cBarCode.setShowT(barcodeObject.isShowText());
        if (!(outputValue instanceof MapField)) return cBarCode;
        MapField mapField = (MapField)outputValue;
        Map config = (Map)mapField.getValue();
        Object v = config.get("barcode");
        if (StringUtils.isBlank(v)) {
            String string = barcodeObject.getSampleTxt();
        }
        if (StringUtils.isBlank((Object)var8_10)) {
            return null;
        }
        cBarCode.setText(var8_10.toString());
        String barcodeType = String.valueOf(config.get("barcodeType"));
        if (StringUtils.equals((CharSequence)"ean-13", (CharSequence)barcodeType)) {
            int length = cBarCode.getText().length();
            if (length != 12 && length != 13) return null;
            cBarCode.setModel(13);
        } else if (StringUtils.equals((CharSequence)"code39", (CharSequence)barcodeType)) {
            cBarCode.setModel(25);
        } else if (StringUtils.equals((CharSequence)"ean-128", (CharSequence)barcodeType)) {
            cBarCode.setModel(16);
            try {
                String string = EAN128Utils.buildHumanReadableMsg(cBarCode.getText());
            }
            catch (Exception e) {
                return null;
            }
        } else {
            cBarCode.setModel(20);
        }
        Object rotateObj = config.get("rotate");
        if (rotateObj != null) {
            Integer rotate = (Integer)rotateObj;
            cBarCode.setRotate(rotate);
            if (rotate == 90 || rotate == 270) {
                float xCenter = cBarCode.getX() + rectangle.width / 2;
                float yCenter = cBarCode.getY() + rectangle.height / 2;
                float oriX = xCenter - (float)(rectangle.height / 2);
                float oriY = yCenter - (float)(rectangle.width / 2);
                cBarCode.setX((int)oriX);
                cBarCode.setY((int)oriY);
                int tempHeight = rectangle.height;
                cBarCode.setH(rectangle.width);
                cBarCode.setW(tempHeight);
            }
        }
        cBarCode.setText(var8_12.toString());
        return cBarCode;
    }
}

