/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender.convert;

import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.execute.qrender.CGrid;
import kd.bos.print.core.execute.qrender.CGridCell;
import kd.bos.print.core.execute.qrender.CGridRow;
import kd.bos.print.core.execute.qrender.convert.CPageConvert;
import kd.bos.print.core.execute.qrender.convert.CRenderConvert;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridColumn;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;

public class CGridConvert
extends CRenderConvert<AbstractPWGrid, CGrid> {
    public CGridConvert(CPageConvert pageConvert) {
        super(pageConvert);
    }

    @Override
    protected CGrid createCRender() {
        return new CGrid();
    }

    @Override
    protected CGrid parseFormWidget(AbstractPWGrid pwGrid) {
        CGrid cGrid = this.createCRender();
        super.fillBaseProperty(pwGrid, cGrid);
        if (pwGrid instanceof PWDataGrid) {
            this.handDataGrid((PWDataGrid)pwGrid, cGrid);
        } else {
            this.handPWGrid(pwGrid, cGrid);
        }
        return cGrid;
    }

    private void handDataGrid(PWDataGrid pwGrid, CGrid cGrid) {
        List outputRows = pwGrid.getOutputRows();
        int addY = 0;
        int addHCellY = 0;
        for (AbstractPWGridRow row : outputRows) {
            int i;
            ArrayList<Object> subCols;
            int columnCount;
            PWDataGrid subDataGrid;
            List cols = pwGrid.getOutputColumns();
            if (row.isSubRow()) {
                subDataGrid = pwGrid.getSubDataGrids().get(0);
                columnCount = subDataGrid.getColumnCount();
                subCols = new ArrayList(10);
                for (i = 0; i < columnCount; ++i) {
                    subCols.add(subDataGrid.getColumn(i));
                }
                cols = subCols;
            }
            if (pwGrid.getSubDataGrids() != null && !pwGrid.getSubDataGrids().isEmpty() && "right".equals((subDataGrid = pwGrid.getSubDataGrids().get(0)).getSubGridDirection())) {
                columnCount = subDataGrid.getColumnCount();
                subCols = new ArrayList(10);
                for (int j = 0; j < pwGrid.getOutputColumns().size(); ++j) {
                    subCols.add(pwGrid.getOutputColumn(j));
                }
                for (i = 0; i < columnCount; ++i) {
                    subCols.add(subDataGrid.getColumn(i));
                }
                cols = subCols;
            }
            CGridRow cGridRow = new CGridRow();
            cGridRow.setHeight(row.getHeight());
            int addX = 0;
            int addedMaxHCellY = 0;
            for (i = 0; i < cols.size(); ++i) {
                Object cell = row.getCell(i);
                if (cell != null) {
                    boolean isHSubCell;
                    boolean bl = isHSubCell = ((AbstractPWGridCell)cell).isSubCell() && (((AbstractPWGridCell)cell).getCellValue() instanceof CellValueText || ((AbstractPWGridCell)cell).getCellValue() instanceof CellValueField);
                    if (isHSubCell) {
                        addedMaxHCellY = addedMaxHCellY == 0 ? Math.max(addedMaxHCellY, ((AbstractPrintWidget)cell).getRectangle().height) : Math.min(addedMaxHCellY, ((AbstractPrintWidget)cell).getRectangle().height);
                    }
                    if (!row.isAdjustHeight()) {
                        ((AbstractPrintWidgetText)cell).setAdjustHeight(false);
                    }
                    CGridCell cLabel = this.parentPageV.getGridCellConvert().parseFormWidget((AbstractPWGridCell)cell);
                    cLabel.setX(cLabel.getX() + addX);
                    if (isHSubCell) {
                        cLabel.setY(cLabel.getY() + addHCellY);
                    } else {
                        cLabel.setY(cLabel.getY() + addY);
                    }
                    if (cGrid.getStyle() == null) {
                        cGrid.setStyle(cLabel.getStyle());
                    }
                    if (cGrid.getStyle().equal(cLabel.getStyle())) {
                        cLabel.setStyle(null);
                    }
                    cGridRow.getChildren().add(cLabel);
                }
                addX += ((PWDataGridColumn)cols.get(i)).getWidth();
            }
            addY += cGridRow.getHeight();
            addHCellY += addedMaxHCellY;
            cGrid.getChildren().add(cGridRow);
        }
        cGrid.setH(addY);
    }

    private void handPWGrid(AbstractPWGrid pwGrid, CGrid cGrid) {
        List outputRows = pwGrid.getOutputRows();
        List cols = pwGrid.getOutputColumns();
        int addY = 0;
        for (AbstractPWGridRow row : outputRows) {
            CGridRow cGridRow = new CGridRow();
            cGridRow.setHeight(row.getHeight());
            int addX = 0;
            for (int i = 0; i < cols.size(); ++i) {
                Object cell = row.getCell(i);
                if (cell != null) {
                    if (!row.isAdjustHeight()) {
                        ((AbstractPrintWidgetText)cell).setAdjustHeight(false);
                    }
                    CGridCell cLabel = this.parentPageV.getGridCellConvert().parseFormWidget((AbstractPWGridCell)cell);
                    cLabel.setX(cLabel.getX() + addX);
                    cLabel.setY(cLabel.getY() + addY);
                    if (cGrid.getStyle() == null) {
                        cGrid.setStyle(cLabel.getStyle());
                    }
                    if (cGrid.getStyle().equal(cLabel.getStyle())) {
                        cLabel.setStyle(null);
                    }
                    cGridRow.getChildren().add(cLabel);
                }
                addX += ((AbstractPWGridColumn)cols.get(i)).getWidth();
            }
            addY += cGridRow.getHeight();
            cGrid.getChildren().add(cGridRow);
        }
        cGrid.setH(addY);
    }
}

