/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender.convert;

import java.util.Base64;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.qrender.CImage;
import kd.bos.print.core.execute.qrender.convert.CPageConvert;
import kd.bos.print.core.execute.qrender.convert.CRenderConvert;
import kd.bos.print.core.model.widget.PWPicture;

public class CImageConvert
extends CRenderConvert<PWPicture, CImage> {
    public CImageConvert(CPageConvert pageConvert) {
        super(pageConvert);
    }

    @Override
    protected CImage createCRender() {
        return new CImage();
    }

    @Override
    public CImage parseFormWidget(PWPicture widget) {
        CImage cImage = this.createCRender();
        super.fillBaseProperty(widget, cImage);
        Style style = widget.getStyle();
        cImage.setBorder(this.parseBorder(style));
        cImage.setScale(widget.getScaleType());
        Field field = widget.getOutputValue();
        if (field instanceof TextField) {
            field = new ImageField((String)((TextField)field).getValue());
        }
        if (!(field instanceof ImageField)) {
            return null;
        }
        ImageField outputValue = (ImageField)field;
        String imageKey = (String)outputValue.getValue();
        byte[] imageByte = outputValue.getImageByte();
        cImage.setImgK(imageKey);
        if (imageByte != null && imageByte.length > 0) {
            String data = Base64.getEncoder().encodeToString(imageByte);
            cImage.setImg(data);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(style.getHorizontalAlign().getValue()).append(";").append(style.getVerticalAlign().getValue());
        cImage.setAlign(builder.toString());
        return cImage;
    }
}

