/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender.convert;

import java.awt.Rectangle;
import java.math.BigDecimal;
import kd.bos.print.core.ctrl.kdf.util.style.Border;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.execute.qrender.CLine;
import kd.bos.print.core.execute.qrender.convert.CPageConvert;
import kd.bos.print.core.execute.qrender.convert.CRenderConvert;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWLine;

public class CLineConvert<T extends PWLine>
extends CRenderConvert<T, CLine> {
    public CLineConvert(CPageConvert pageConvert) {
        super(pageConvert);
    }

    @Override
    protected CLine createCRender() {
        return new CLine();
    }

    @Override
    protected CLine parseFormWidget(T widget) {
        CLine line = this.createCRender();
        super.fillBaseProperty(widget, line);
        Rectangle react = ((AbstractPrintWidget)widget).getRectangle();
        if ("V".equals(((PWLine)widget).getDirection())) {
            float xCenter = line.getX() + react.width / 2;
            float yCenter = line.getY() + react.height / 2;
            float oriX = xCenter - (float)(react.height / 2);
            float oriY = yCenter - (float)(react.width / 2);
            line.setX((int)oriX);
            line.setY((int)oriY);
            int tempHeight = react.height;
            line.setH(react.width);
            line.setW(tempHeight);
            line.setRotate(90);
        }
        Border border = ((AbstractPrintWidget)widget).getStyle().getBorder(Styles.Position.BOTTOM);
        StringBuilder builder = new StringBuilder();
        this.parseSingleBorder(border, builder);
        double lineWidth = KPrintUtil.lomToPrintPoint(line.getW());
        BigDecimal lineWidthDecimal = BigDecimal.valueOf(lineWidth);
        String lineWidthStr = lineWidthDecimal.setScale(1, 4).toPlainString();
        builder.append(lineWidthStr);
        line.setlStyle(builder.toString());
        return line;
    }

    @Override
    protected void parseSingleBorder(Border pwBorder, StringBuilder builder) {
        builder.append(this.colorToHex(pwBorder.getColor())).append("_").append(pwBorder.getPenStyle().getName()).append("_");
    }
}

