/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender.convert;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.execute.qrender.CQRCode;
import kd.bos.print.core.execute.qrender.convert.CPageConvert;
import kd.bos.print.core.execute.qrender.convert.CRenderConvert;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.widget.barcode.PWBarcode;

public class CQRCodeConvert
extends CRenderConvert<PWBarcode, CQRCode> {
    public CQRCodeConvert(CPageConvert pageConvert) {
        super(pageConvert);
    }

    @Override
    protected CQRCode createCRender() {
        return new CQRCode();
    }

    @Override
    protected CQRCode parseFormWidget(PWBarcode pwBarcode) {
        CQRCode cQrCode = this.createCRender();
        super.fillBaseProperty(pwBarcode, cQrCode);
        Field outputValue = pwBarcode.getOutputValue();
        BarcodeObject barcodeObject = pwBarcode.getBarcodeObject();
        cQrCode.setEcl(barcodeObject.getErrorCorrection());
        if (outputValue instanceof MapField) {
            MapField mapField = (MapField)outputValue;
            Map config = (Map)mapField.getValue();
            Object barcodeVal = config.get("barcode");
            if (StringUtils.isBlank(barcodeVal)) {
                barcodeVal = barcodeObject.getSampleTxt();
            }
            if (StringUtils.isBlank(barcodeVal)) {
                return null;
            }
            cQrCode.setText(barcodeVal.toString());
        }
        return cQrCode;
    }
}

