/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender.convert;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.entity.param.CustomParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.execute.qrender.CImage;
import kd.bos.print.core.execute.qrender.convert.CPageConvert;
import kd.bos.print.core.execute.qrender.convert.CRenderConvert;
import kd.bos.print.core.model.widget.PWRichText;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class CRichTextConvert
extends CRenderConvert<PWRichText, CImage> {
    private Log log = LogFactory.getLog(CRichTextConvert.class);

    public CRichTextConvert(CPageConvert parentPage) {
        super(parentPage);
    }

    @Override
    protected CImage createCRender() {
        return new CImage();
    }

    @Override
    protected CImage parseFormWidget(PWRichText richText) {
        CImage cImage = this.createCRender();
        super.fillBaseProperty(richText, cImage);
        cImage.setBorder(this.parseBorder(richText.getStyle()));
        try {
            BufferedImage image = this.parseToImage(richText);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", out);
            String data = Base64.getEncoder().encodeToString(out.toByteArray());
            out.close();
            cImage.setImg(data);
            cImage.setScale(1);
        }
        catch (Exception e) {
            this.log.error("\u5bcc\u6587\u672c\u8f6c\u56fe\u7247\u5931\u8d25\u3002", (Throwable)e);
            return null;
        }
        return cImage;
    }

    private BufferedImage parseToImage(PWRichText richText) throws IOException {
        ByteArrayOutputStream os = (ByteArrayOutputStream)richText.getHtmlPDFos();
        PDDocument pdfDocument = PDDocument.load((byte[])os.toByteArray());
        PDFRenderer renderer = new PDFRenderer(pdfDocument);
        CustomParam customParam = new CustomParam();
        HashSet<String> set = new HashSet<String>();
        String key = "KDPrintClient_DPI";
        set.add(key);
        customParam.setSearchKeySet(set);
        Map parameterMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        float useDpi = KDToolkit.getCurrentDpi();
        String printerDpi = (String)parameterMap.get(key);
        if (printerDpi != null) {
            useDpi = Float.parseFloat(printerDpi);
        }
        BufferedImage image = renderer.renderImageWithDPI(richText.getPdfPageNum() - 1, useDpi);
        int height = (int)(this.lomToPixel(richText.getRectangle().getHeight(), useDpi) + 1L);
        if (height < image.getHeight()) {
            BufferedImage subImage = image.getSubimage(0, 0, image.getWidth(), height);
            return subImage;
        }
        return image;
    }

    private long lomToPixel(double x, float dpi) {
        return (long)Math.ceil(x * (double)dpi / (double)254.3f);
    }
}

