/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render;

import java.util.List;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.render.ImageRenderCaptain;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.export.AbstractPrtExport;
import kd.bos.print.core.execute.render.export.SingleImagePrtExport;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.pwpainer.image.ImagePaperPainter;
import kd.bos.print.core.utils.PrintConst;
import kd.bos.svc.acl.AclAdapter;

public class ClientPreviewRenderCaptain
extends ImageRenderCaptain {
    protected static final DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    protected int pageTotal;
    private int maxPreviewNum = PrintConst.getMaxPreviewNum();

    public ClientPreviewRenderCaptain(ExecuteLife executeLife) {
        super(executeLife);
        this.ontPdfPage = 1;
    }

    public ClientPreviewRenderCaptain(ExecuteLife executeLife, int maxPreviewNum) {
        super(executeLife);
        this.ontPdfPage = 1;
        this.maxPreviewNum = maxPreviewNum;
    }

    public void put(APaperPainter paper) throws InterruptedException {
        if (this.pageTotal <= this.maxPreviewNum - 1) {
            if (paper instanceof ImagePaperPainter) {
                ++this.pageTotal;
            }
            this.putToRender(paper);
        } else {
            if (!(paper instanceof ImagePaperPainter)) {
                this.putToRender(paper);
            }
            this.executeLife.setStopCompute();
        }
    }

    @Override
    protected AbstractPrtExport createPdfExport() {
        return new SingleImagePrtExport();
    }

    protected void putToRender(APaperPainter paper) throws InterruptedException {
        super.put(paper);
    }

    public void endPut(int showPageTotal) {
        distributeCache.put(ExecuteContext.get().getTaskId() + "_imagenum", (Object)String.valueOf(this.pageTotal));
    }

    public int getPageTotal() {
        return this.pageTotal;
    }

    @Override
    public void endWork() throws InterruptedException {
        List<RenderCaptain.WorkNode> nodes = this.workQueue.nodes;
        for (RenderCaptain.WorkNode node : nodes) {
            node.work.endWork();
        }
        this.shareResource.release();
    }
}

