/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.render.ClientPreviewRenderCaptain;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumUtil;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWText;

public class ClientPreviewTotalPageCaptain
extends ClientPreviewRenderCaptain {
    private List<APaperPainter> paperPainterList = new ArrayList<APaperPainter>(50);
    private DelayVarProvider delayVarProvider = new DelayVarProvider();

    public ClientPreviewTotalPageCaptain(ExecuteLife executeLife) {
        super(executeLife);
    }

    @Override
    protected void putToRender(APaperPainter paper) throws InterruptedException {
        this.paperPainterList.add(paper);
    }

    @Override
    public void endPut(int showPageTotal) {
        distributeCache.put(ExecuteContext.get().getTaskId() + "_imagenum", (Object)String.valueOf(this.pageTotal));
        try {
            Consumer<PWText> consumer = pwText -> this.delayVarProvider.fillValue("pageTotal", (AbstractPrintWidgetText)pwText, new IntegerField(showPageTotal));
            for (APaperPainter paperPainter : this.paperPainterList) {
                PWPage pwPage = (PWPage)paperPainter.getPaintObj();
                PageNumUtil.recoreTotalWidget(pwPage.getChildren(), consumer);
                super.putToRender(paperPainter);
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            throw new PrintException("-1", e);
        }
    }
}

