/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.ExecutionException;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.PFileStorageType;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.painter.pwpainer.PaperPainter;
import kd.bos.print.core.label.cpcl.CpclBuilder;
import kd.bos.print.core.label.cpcl.CpclUtils;
import kd.bos.print.core.service.PrtAttach;

public class CpclRenderCaptain
extends RenderCaptain<PaperPainter> {
    private CpclUtils cpclUtils = new CpclUtils();

    public CpclRenderCaptain(ExecuteLife executeLife) {
        super(executeLife);
    }

    @Override
    public void put(PaperPainter paper) throws InterruptedException {
        this.cpclUtils.addPage(paper);
    }

    @Override
    public void endWork() throws ExecutionException, InterruptedException {
        super.endWork();
        try {
            CpclBuilder builder = this.cpclUtils.getBuilder();
            PrtAttach prtAttach = new PrtAttach();
            prtAttach.setAppId(ExecuteContext.get().getAppId());
            prtAttach.setFormId(ExecuteContext.get().getFormId());
            prtAttach.setExtType(ExecuteContext.get().getExpType());
            prtAttach.setTaskId(ExecuteContext.get().getTaskId());
            prtAttach.setUserId(ExecuteContext.get().getServiceProxy().getUserService().getUserId());
            prtAttach.setTaskName("cpcl-" + ExecuteContext.get().getTplKey());
            String fileName = ExecuteContext.get().getTplKey() + ".txt";
            PrtAttach.AttachDetail detail = new PrtAttach.AttachDetail();
            detail.setFileName(fileName);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(builder.build());
            ExecuteContext.get().setpFileStorageType(new PFileStorageType("2", 1800));
            String filePath = ExecuteService.getAttachService().savePrtFile(fileName, outputStream.toByteArray());
            detail.setFilePath(filePath);
            prtAttach.addAttachDetail(detail);
            prtAttach.setDiskType("2");
            ExecuteContext.get().getServiceProxy().getAttachmentService().savePrtResult(prtAttach);
            this.cpclUtils.release();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

