/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.FileUtil;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.export.AbstractPrtExport;
import kd.bos.print.core.execute.render.export.DiskPdfExport;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.PaperPainter;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumItem;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumRecord;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PageNumUtil;
import kd.bos.print.core.execute.render.painter.pwpainer.pagenum.PaperNumRender;
import kd.bos.print.core.execute.render.painter.share.ShareResource;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.service.PrtAttach;

public class DiskRenderCaptain
extends RenderCaptain<PaperPainter> {
    private PageNumRecord pageNumRecord = new PageNumRecord();
    private Integer pageSize;
    private Map<Integer, List<PageNumItem>> integerListMap;
    private int numIndex;
    private PaintPaperInfo paperInfo = null;

    public DiskRenderCaptain(ExecuteLife executeLife) {
        super(executeLife);
    }

    @Override
    protected AbstractPrtExport createPdfExport() {
        return new DiskPdfExport();
    }

    public PageNumRecord getPageNumRecord() {
        return this.pageNumRecord;
    }

    @Override
    public void put(PaperPainter paper) throws InterruptedException {
        PWPage pwPage = (PWPage)paper.getPaintObj();
        if (this.paperInfo == null) {
            this.paperInfo = paper.getPaperInfo();
        }
        List<PageNumItem> pageNumItems = PageNumUtil.removeTotalPageWidget(pwPage);
        super.put(paper);
        ++this.numIndex;
        if (pageNumItems != null && !pageNumItems.isEmpty()) {
            if (this.integerListMap == null) {
                this.integerListMap = new TreeMap<Integer, List<PageNumItem>>();
            }
            this.integerListMap.put(this.numIndex, pageNumItems);
        }
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    protected void afterEndOne() {
        if (this.integerListMap != null) {
            this.pageNumRecord.putPageNumItems(this.pdfIndex, this.integerListMap);
            this.integerListMap = null;
        }
    }

    @Override
    public void finish() {
        String path = File.separator + "temp" + File.separator + ExecuteContext.get().getTaskId();
        FileUtil.deleteFile(path);
    }

    @Override
    protected void handPrtResult(ShareResource shareResource) {
        PrtAttach attach = shareResource.getAttach();
        if (this.executeLife.isStop()) {
            this.log.info("\u6253\u5370\u5df2\u7ecf\u8fdb\u5165\u9875\u7801\u91cd\u7ed8\u9636\u6bb5\uff0c\u5916\u90e8\u5f3a\u5236\u7ec8\u6b62\uff0c\u9000\u51fa\u91cd\u7ed8");
            return;
        }
        if (this.integerListMap != null) {
            this.pageNumRecord.putPageNumItems(this.pdfIndex, this.integerListMap);
            this.integerListMap = null;
        }
        long t1 = System.currentTimeMillis();
        int usePdfSize = shareResource.getToalPageSize();
        if (this.pageSize != null) {
            usePdfSize = this.pageSize;
        }
        PaperNumRender render = new PaperNumRender(this.pageNumRecord, usePdfSize, this.executeLife, this.paperInfo);
        render.render(attach);
        this.pageNumRecord.release();
        this.log.debug("\u7ed8\u5236\u9875\u9762\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1));
        ExecuteService.getAttachService().savePrtResult(attach);
    }
}

