/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.convert.PrintWidgetEscConvert;
import kd.bos.print.core.esc.model.EPage;
import kd.bos.print.core.esc.writer.EscWriter;
import kd.bos.print.core.execute.render.export.AbstractPrtExport;
import kd.bos.print.core.execute.render.painter.pwpainer.image.ImagePaperPainter;
import kd.bos.print.core.service.PrtAttach;

public abstract class EscPrtExport
extends AbstractPrtExport<ImagePaperPainter> {
    private PrintWidgetEscConvert convert;
    private EscWriter writer;

    @Override
    protected OutputStream createOs() {
        return new ByteArrayOutputStream();
    }

    @Override
    public void begin(ImagePaperPainter paper) {
        super.begin(paper);
        EscPos escPos = new EscPos(this.os);
        this.convert = this.createPageConvert();
        this.writer = this.createPageWriter(escPos);
    }

    protected abstract PrintWidgetEscConvert createPageConvert();

    protected abstract EscWriter createPageWriter(EscPos var1);

    @Override
    public void export(ImagePaperPainter painter) {
        if (this.os == null) {
            this.begin(painter);
        }
        if (this.convert == null || this.writer == null) {
            return;
        }
        EPage ePage = this.convert.convert(painter);
        if (ePage == null) {
            return;
        }
        this.writer.write(ePage);
    }

    @Override
    public void endOne() throws Exception {
        String fileName = this.getFileName();
        this.os.flush();
        PrtAttach.AttachDetail attachDetail = new PrtAttach.AttachDetail();
        attachDetail.setFileName(fileName);
        attachDetail.setSource("B");
        attachDetail.setSeq(this.curFileIndex);
        String filePath = this.savePrtFile(attachDetail.getFileName(), this.os);
        attachDetail.setFilePath(filePath);
        this.attachList.add(attachDetail);
        this.os.close();
    }

    @Override
    protected String getFileNameSuffix() {
        return ExecuteContext.get().getExpType();
    }
}

