/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.convert.PrintWidgetEscConvert;
import kd.bos.print.core.esc.model.EPage;
import kd.bos.print.core.esc.writer.EscWriter;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.qrender.CJob;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.image.ImagePaperPainter;
import kd.bos.print.core.service.IClientService;
import kd.bos.print.core.utils.HexUtil;
import org.apache.commons.lang.StringUtils;

public abstract class EscRenderCaptain
extends RenderCaptain<ImagePaperPainter> {
    private String taskName;
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();
    private final PrintWidgetEscConvert convert;
    private final EscWriter writer;

    public EscRenderCaptain(ExecuteLife executeLife) {
        super(executeLife);
        EscPos escPos = new EscPos(this.os);
        this.convert = this.createPageConvert();
        this.writer = this.createPageWriter(escPos);
    }

    protected abstract PrintWidgetEscConvert createPageConvert();

    protected abstract EscWriter createPageWriter(EscPos var1);

    @Override
    public ImagePaperPainter createPaperPainter(PaintPaperInfo paperInfo) {
        return new ImagePaperPainter(paperInfo);
    }

    @Override
    public void put(ImagePaperPainter painter) throws InterruptedException {
        if (StringUtils.isBlank((String)this.taskName)) {
            this.taskName = painter.getTplName();
        }
        if (this.convert == null || this.writer == null) {
            return;
        }
        EPage page = this.convert.convert(painter);
        this.writer.write(page);
    }

    @Override
    public void endWork() throws ExecutionException, InterruptedException {
        super.endWork();
        try {
            String hexStr = HexUtil.encodeHexStr(this.os.toByteArray());
            CJob<String> cJob = new CJob<String>();
            cJob.setType("J3");
            cJob.setTaskId(ExecuteContext.get().getTaskId());
            cJob.setTaskName(this.taskName);
            cJob.setJobName(this.taskName);
            cJob.setInfo(hexStr);
            cJob.setSeq(0);
            cJob.setEnd(true);
            IClientService clientService = ExecuteContext.get().getServiceProxy().getClientService();
            if (clientService != null) {
                clientService.execute(cJob);
            }
            this.os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

