/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.LimitCallable;
import kd.bos.print.core.execute.render.Release;
import kd.bos.print.core.execute.render.export.AbstractPrtExport;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.EndOnePaper;
import kd.bos.print.core.execute.render.painter.EndPaper;
import kd.bos.print.core.execute.render.painter.PainterFactory;

public class PainerWork
implements LimitCallable,
Release {
    private Log log = LogFactory.getLog(PainerWork.class);
    private BlockingQueue<APaperPainter> queue = new LinkedBlockingQueue<APaperPainter>(800);
    private AbstractPrtExport pdfExport;
    private ExecuteContext executeContext;
    private ExecuteLife executeLife;
    private String concurrentID;

    public PainerWork(AbstractPrtExport pdfExport, ExecuteLife executeLife) {
        this.pdfExport = pdfExport;
        this.executeLife = executeLife;
        this.executeContext = ExecuteContext.get();
    }

    @Override
    public void setConcurrentID(String concurrentID) {
        this.concurrentID = concurrentID;
    }

    public int size() {
        return this.queue.size();
    }

    public void put(APaperPainter e) throws InterruptedException {
        if (!this.executeLife.isRunSuccess()) {
            throw new PrintException("-1", ResManager.loadKDString((String)"\u6253\u5370\u5f15\u64ce\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c\u6d88\u8d39\u7ebf\u7a0b\u9000\u51fa\u8ba1\u7b97\u3002", (String)"PainerWork_0", (String)"bos-print-core", (Object[])new Object[0]));
        }
        if (this.executeLife.isStop()) {
            throw new PrintException("-1", ResManager.loadKDString((String)"\u5916\u90e8\u5f3a\u5236\u7ec8\u6b62\uff0c\u6d88\u8d39\u7ebf\u7a0b\u9000\u51fa\u8ba1\u7b97\u3002", (String)"PainerWork_1", (String)"bos-print-core", (Object[])new Object[0]));
        }
        boolean isSuccess = this.queue.offer(e, 30L, TimeUnit.SECONDS);
        if (!isSuccess) {
            this.put(e);
        }
    }

    @Override
    public Object call() throws Exception {
        ExecuteContext.set(this.executeContext);
        try {
            this.doPaint();
        }
        catch (Throwable throwable) {
            this.executeLife.setConsumeErr();
            this.log.warn("\u6d88\u8d39\u7ebf\u7a0b\u5f02\u5e38\uff1a", throwable);
            throw throwable;
        }
        finally {
            this.release();
            ConcurrencyLimiter.release((String)this.concurrentID);
        }
        return true;
    }

    @Override
    public void release() {
        if (this.pdfExport instanceof Release) {
            Release release = (Release)((Object)this.pdfExport);
            release.release();
        }
        PainterFactory.get().release();
    }

    public void doPaint() throws Exception {
        int maxSize = 0;
        while (!this.executeLife.isStop() && this.executeLife.isRunSuccess()) {
            int size = this.queue.size();
            if (size > maxSize) {
                maxSize = size;
            }
            APaperPainter paper = this.queue.poll(30L, TimeUnit.SECONDS);
            if (this.executeLife.isStop()) {
                this.log.info("\u5916\u90e8\u5f3a\u5236\u7ec8\u6b62\uff0c\u6d88\u8d39\u7ebf\u7a0b\u9000\u51fa\u8ba1\u7b97\u3002");
                break;
            }
            if (paper == null) {
                if (this.executeLife.computeIsAlive()) continue;
                this.log.info("\u8ba1\u7b97\u7ebf\u7a0b\u5df2\u6b7b,\u6d88\u8d39\u7ebf\u7a0b\u5c06\u81ea\u52a8\u7ec8\u6b62" + Thread.currentThread());
                break;
            }
            if (paper instanceof EndOnePaper) {
                this.pdfExport.endOne();
                continue;
            }
            if (paper instanceof EndPaper) {
                this.pdfExport.end();
                this.log.info("\u6d88\u8d39\u6267\u884c\u5b8c\u6bd5End\uff1a" + Thread.currentThread());
                break;
            }
            if (!(paper instanceof APaperPainter)) continue;
            this.pdfExport.export(paper);
        }
        if (this.executeLife.isStop() && this.queue.size() > 0) {
            this.queue.clear();
        }
        if (this.executeLife.isStop()) {
            this.log.info("\u5916\u90e8\u5f3a\u5236\u7ec8\u6b62\uff0c\u6d88\u8d39\u7ebf\u7a0b\u9000\u51fa\u8ba1\u7b97\u3002");
        }
    }

    public void endWork() throws InterruptedException {
        this.put(EndPaper.getInstance());
    }
}

