/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.FileUtil;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.PrintJobPool;
import kd.bos.print.core.execute.render.PainerWork;
import kd.bos.print.core.execute.render.export.AbstractPrtExport;
import kd.bos.print.core.execute.render.export.PdfPrtExport;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.BasePainter;
import kd.bos.print.core.execute.render.painter.EndOnePaper;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.PaperPainter;
import kd.bos.print.core.execute.render.painter.share.ShareResource;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.BeforeExportEvent;
import kd.bos.print.core.plugin.event.EndExportEvent;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.core.utils.PrintConst;

public class RenderCaptain<T extends APaperPainter> {
    protected WorkQueue workQueue = new WorkQueue();
    protected int ontPdfPage = PrintConst.onePdfMaxPage();
    private boolean startNewBill;
    private boolean pdfIndexAdd;
    protected ShareResource shareResource = new ShareResource();
    protected Log log = LogFactory.getLog(this.getClass());
    protected int addNum = 0;
    protected int pdfIndex = 1;
    protected ExecuteLife executeLife;

    public RenderCaptain(ExecuteLife executeLife) {
        this.executeLife = executeLife;
    }

    public APaperPainter createPaperPainter(PaintPaperInfo paperInfo) {
        return new PaperPainter(paperInfo);
    }

    protected int getMaxConsumeThread() {
        return PrintConst.maxConsumeThread();
    }

    public void put(T paper) throws InterruptedException {
        ++this.addNum;
        String fileName = null;
        WorkNode workNode = this.workQueue.curent();
        if (workNode == null) {
            this.createPainer();
            workNode = this.workQueue.curent();
            fileName = this.getFileName(paper);
            this.shareResource.setFileName(fileName);
            ((APaperPainter)paper).setFileName(fileName);
        }
        if (this.addNum > this.ontPdfPage || this.startNewBill) {
            if (this.startNewBill) {
                if (this.pdfIndexAdd) {
                    ++this.pdfIndex;
                }
                this.startNewBill = false;
            } else {
                ++this.pdfIndex;
            }
            if (fileName == null) {
                fileName = this.getFileName(paper);
                ((APaperPainter)paper).setFileName(fileName);
            }
            workNode.work.put(EndOnePaper.getInstance());
            this.afterEndOne();
            this.addNum = 1;
            if (this.workQueue.size() <= this.getMaxConsumeThread() - 1) {
                this.createPainer();
                workNode = this.workQueue.next();
            } else {
                workNode = this.workQueue.findFree();
            }
        }
        PainerWork work = workNode.work;
        ((BasePainter)paper).getPaintContext().setShareResource(this.shareResource);
        ((APaperPainter)paper).setFileIndex(this.pdfIndex);
        work.put((APaperPainter)paper);
    }

    public void resetWithFileNameCustom() {
        this.pdfIndex = 1;
        this.addNum = 1;
        this.startNewBill = true;
    }

    public void resetWithFileNameNormal() {
        this.addNum = 1;
        this.startNewBill = true;
        this.pdfIndexAdd = true;
    }

    private String getFileName(T paper) {
        String fileName = ((APaperPainter)paper).getTplName();
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeExportEvent evt = new BeforeExportEvent();
            evt.setFileTplName(fileName);
            pluginProxy.fireBeforeExport(evt);
            fileName = evt.getFileTplName();
        }
        return fileName;
    }

    protected void afterEndOne() {
    }

    public void endWork() throws ExecutionException, InterruptedException {
        PrintPluginProxy pluginProxy;
        List<WorkNode> nodes = this.workQueue.nodes;
        for (WorkNode node : nodes) {
            node.work.endWork();
        }
        for (WorkNode node : nodes) {
            node.future.get();
        }
        PrtAttach attach = this.shareResource.getAttach();
        if (attach != null && attach.getAttachDetail() != null && attach.getAttachDetail().size() > 0) {
            this.handPrtResult(this.shareResource);
        }
        if ((pluginProxy = ExecuteContext.get().getPluginProxy()) != null) {
            EndExportEvent evt = new EndExportEvent();
            evt.setPrtAttach(attach);
            evt.setPageTotal(this.shareResource.getPdfPageSize());
            pluginProxy.fireEndOutput(evt);
        }
        this.shareResource.release();
    }

    protected void handPrtResult(ShareResource shareResource) {
        PrtAttach attach = shareResource.getAttach();
        ExecuteService.getAttachService().savePrtResult(attach);
    }

    public void finish() {
        String path = File.separator + "temp" + File.separator + ExecuteContext.get().getTaskId();
        FileUtil.deleteFile(path);
    }

    private void createPainer() {
        PainerWork painerWork = new PainerWork(this.createPdfExport(), this.executeLife);
        Future<Object> submit = PrintJobPool.submit(painerWork);
        this.workQueue.add(new WorkNode(painerWork, submit));
    }

    protected AbstractPrtExport createPdfExport() {
        return new PdfPrtExport();
    }

    protected static class WorkQueue {
        protected List<WorkNode> nodes = new ArrayList<WorkNode>(2);
        private int curIndex = 0;

        protected WorkQueue() {
        }

        public void add(WorkNode node) {
            this.nodes.add(node);
        }

        public int size() {
            return this.nodes.size();
        }

        public WorkNode curent() {
            if (this.nodes.size() == 0) {
                return null;
            }
            return this.nodes.get(this.curIndex);
        }

        public WorkNode findFree() {
            int freeIndex = 0;
            int workSize = 0;
            for (int i = 0; i < this.nodes.size(); ++i) {
                int size = this.nodes.get((int)i).work.size();
                if (i != 0 && size >= workSize) continue;
                workSize = size;
                freeIndex = i;
            }
            this.curIndex = freeIndex;
            return this.nodes.get(freeIndex);
        }

        public WorkNode next() {
            ++this.curIndex;
            if (this.curIndex >= this.nodes.size()) {
                this.curIndex = 0;
            }
            return this.curent();
        }
    }

    protected static class WorkNode {
        protected PainerWork work;
        private Future future;

        WorkNode(PainerWork work, Future future) {
            this.work = work;
            this.future = future;
        }
    }
}

