/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.render.layout.ITextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.TextRenderParam;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.DivideCharacterRenderer;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.IDivideCharacterSupport;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;
import kd.bos.print.core.model.ui.component.IRender;
import kd.bos.print.core.model.ui.component.R1PLabelCell;

public class AdjustHeightRender
implements IRender {
    private boolean blackWhite;

    public void setBlackWhite(boolean isBlackWhite) {
        this.blackWhite = isBlackWhite;
    }

    public static final AdjustHeightRender getInstance() {
        return new AdjustHeightRender();
    }

    @Override
    public void drawText(Graphics g, Rectangle rect, String text, Style style, Object targetObj) {
        LineWrapParam lineWrapParam = null;
        float textHeight = 0.0f;
        float[] flexOffset = null;
        int widgetWidth = 0;
        if (targetObj instanceof R1PLabelCell) {
            R1PLabelCell labelCell = (R1PLabelCell)targetObj;
            textHeight = labelCell.getTextHeight();
            lineWrapParam = labelCell.getLineWrapParam();
            if (lineWrapParam.isWordFlex()) {
                flexOffset = labelCell.getFlexOffset();
            }
            int minWidth = (int)KPrintUtil.lomToPrintPoint(lineWrapParam.getMinW());
            int maxWidth = (int)KPrintUtil.lomToPrintPoint(lineWrapParam.getMaxW());
            int width = minWidth;
            if (lineWrapParam.getRule() == LineWrapRule.NoWrap && !style.isClip()) {
                width = (int)((float)maxWidth - labelCell.getParentX() - labelCell.getX());
                labelCell.setUseAdjustHeightRender(false);
            }
            int minH = (int)KPrintUtil.lomToPrintPoint(lineWrapParam.getMinH());
            Rect padding = style.getPadding();
            int padWidth = padding.getLeft() + padding.getRight();
            int padHeight = padding.getTop() + padding.getBottom();
            rect.x = style.getPadding().getLeft();
            rect.y = style.getPadding().getTop();
            rect.width = width - padWidth;
            rect.height = minH - padHeight;
            widgetWidth = minWidth - padWidth;
            lineWrapParam.minW(minWidth).maxW(maxWidth).minH(minH);
        }
        int divideCharNums = -1;
        if (targetObj instanceof IDivideCharacterSupport) {
            divideCharNums = ((IDivideCharacterSupport)targetObj).getDivideCharNums();
        }
        if (divideCharNums > 0) {
            boolean isDrawBorder = false;
            if (style != null) {
                isDrawBorder = !style.getBorderLineStyle(Styles.Position.LEFT).isNullBorder();
            }
            DivideCharacterRenderer renderer = DivideCharacterRenderer.shareInstance(divideCharNums, isDrawBorder);
            String drawText = "";
            if (text != null) {
                drawText = text;
            }
            renderer.draw(g, rect, drawText, style, targetObj);
        } else if (!StringUtil.isEmptyString(text)) {
            TextRenderParam renderParam = new TextRenderParam((Graphics2D)g, text, rect.getBounds(), lineWrapParam, style, this.blackWhite);
            renderParam.setTextHeight(textHeight);
            renderParam.setFlexOffset(flexOffset);
            renderParam.setWidgetWidth(widgetWidth);
            if (targetObj instanceof R1PLabelCell) {
                R1PLabelCell labelCell = (R1PLabelCell)targetObj;
                renderParam.setAnchor(labelCell.isAnchor());
                renderParam.setLinkUrl(labelCell.getLinkUrl());
            }
            ITextRender.createRender(targetObj, style).drawText(renderParam);
        }
    }
}

