/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.kdf.util.render.layout.ITextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.DrawLineParam;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.util.Util;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.print.core.execute.render.common.AdjustHeightInfo;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;
import kd.bos.print.core.execute.render.common.linewrap.process.AdjustWrapProcess;
import kd.bos.print.core.model.PrintTplVersion;

public class AdjustHeightRenderUtil {
    private static final Log logger = LogFactory.getLog(AdjustHeightRenderUtil.class);

    public static AdjustHeightInfo adjustHeight(String text, Style style, int minH, int maxH, int width) {
        LineWrapParam param = new LineWrapParam.Builder(text, LineWrapRule.ChunkLine).style(style).minW(width).minH(minH).maxH(maxH).offsetY(0).build();
        return AdjustHeightRenderUtil.adjustHeight(param);
    }

    public static AdjustHeightInfo adjustHeight(LineWrapParam param) {
        String tplVer;
        int width = param.getMinW();
        int minH = param.getMinH();
        Style style = param.getStyle();
        int maxH = param.getMaxH();
        int paddingHeight = 0;
        if (style != null) {
            Rect padding = style.getPadding();
            paddingHeight = padding.getTop() + padding.getBottom();
        }
        if ((tplVer = ExecuteContext.get().getTplVer()) == null || tplVer.compareTo(PrintTplVersion.V_7_0_1.getTplVer()) < 0) {
            minH -= paddingHeight;
        }
        AdjustHeightInfo result = AdjustHeightRenderUtil.adjustCal(param.minW(width).minH(minH).maxH(maxH -= paddingHeight).offsetY(0));
        if (result.getUsedHeight() - result.getTextHeight() <= paddingHeight) {
            result.setUsedHeight(result.getUsedHeight() + paddingHeight);
        }
        return result;
    }

    public static void draw(Graphics graphics, Rectangle rect, String text, Style style, float offsetY) {
        AdjustHeightRenderUtil.draw(graphics, rect, text, style, offsetY, null);
    }

    public static void draw(Graphics graphics, Rectangle rect, String text, Style style, float offsetY, float[] flexOffset) {
        if (graphics == null) {
            return;
        }
        Font font = AdjustHeightRenderUtil.createFont(style, style.getKDFont().getSize2D());
        if (font == null) {
            font = style.getFont();
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int wordSpacing = Util.pound2Pixel((int)style.getWordspacing());
        Graphics2D g = (Graphics2D)graphics.create(style.getPadding().getLeft(), style.getPadding().getTop(), rect.width, rect.height + fontMetrics.getAscent());
        g.setColor(style.getFontColor());
        Font font2 = AdjustHeightRenderUtil.createFont(style, style.getKDFont().getSize2D());
        g.setFont(font2);
        LineMetrics lineMetrics = font.getLineMetrics(text, g.getFontRenderContext());
        String[] arr = text.split("\n");
        float y = lineMetrics.getAscent() + offsetY;
        for (int i = 0; i < arr.length; ++i) {
            float xOffset = 0.0f;
            if (flexOffset != null && i < flexOffset.length) {
                xOffset = flexOffset[i];
            }
            AdjustHeightRenderUtil.drawLineText(g, arr[i], y, style, rect.width, xOffset);
            y += AdjustWrapProcess.getLineHeight(lineMetrics, style);
        }
    }

    public static void drawLineText(Graphics2D g, String drawText, float y, Style style, int width, float flexOffset) {
        float x = AdjustHeightRenderUtil.getX(drawText, style, width, flexOffset);
        DrawLineParam param = new DrawLineParam(g, drawText, x, y, flexOffset, style);
        ITextRender.drawLineText(param);
    }

    private static float getX(String drawText, Style style, int width, float flexOffset) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(style.getFont());
        float x = 2.0f;
        int textWidth = 0;
        int charNumber = 0;
        for (int i = 0; i < drawText.length(); ++i) {
            int charWidth = fontMetrics.charWidth(drawText.charAt(i));
            if (charWidth == 0) continue;
            ++charNumber;
            textWidth += charWidth;
        }
        int wordSpace = Util.pound2Pixel((int)style.getWordspacing());
        Styles.HorizontalAlignment align = style.getHorizontalAlign();
        if (align == Styles.HorizontalAlignment.CENTER) {
            x = (float)((width - textWidth - (charNumber - 1) * wordSpace) / 2) - flexOffset * (float)drawText.length() / 2.0f;
        } else if (align == Styles.HorizontalAlignment.RIGHT && (x = (float)(width - textWidth - (charNumber - 1) * wordSpace) - flexOffset * (float)drawText.length()) >= 3.0f) {
            x -= 3.0f;
        }
        if (align == Styles.HorizontalAlignment.LEFT || align == Styles.HorizontalAlignment.JUSTIFY || x < 0.0f) {
            x = 0.0f;
        }
        return x;
    }

    public static AdjustHeightInfo adjustCal(String text, Style style, int minH, int maxH, int width, int offsetY) {
        return AdjustHeightRenderUtil.adjustCal(new LineWrapParam.Builder(text, LineWrapRule.ChunkLine).style(style).minW(width).maxW(width).minH(minH).maxH(maxH).offsetY(offsetY).build());
    }

    public static AdjustHeightInfo adjustCal(LineWrapParam param) {
        return (AdjustHeightInfo)new AdjustWrapProcess(param).process(param.isWordFlex());
    }

    private static Font createFont(Style style, float fontSize) {
        int boldAndItalic = 0;
        boldAndItalic += style.isBold() ? 1 : 0;
        return KDFont.loadFontFromJAR(style.getFontName(), boldAndItalic += style.isItalic() ? 2 : 0, fontSize);
    }
}

