/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common.linewrap;

import com.lowagie.text.Utilities;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.execute.render.common.linewrap.ITextMeasurer;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;
import kd.bos.print.core.execute.render.common.linewrap.split.ITextSplitCharacter;

public class TextChunk {
    private static final char SPACE_CHAR = ' ';
    private static final String SPACE_STRING = " ";
    private static final int FLEX_FACTORY = 8;
    private static final float FLEX_THRESHOLD = 0.7f;
    private final ITextSplitCharacter charSplitManage;
    private String value = "";
    private boolean hardEntry;
    private final ITextMeasurer measurer;
    private final LineWrapRule lineWrapRule;
    private int splitPosition;
    private final boolean wordFlex;
    private float flexOffset = 0.0f;
    private final boolean trimSpace;

    TextChunk(String returnValue, TextChunk chunk) {
        this.value = returnValue;
        this.wordFlex = chunk.wordFlex;
        this.measurer = chunk.measurer;
        this.charSplitManage = chunk.charSplitManage;
        this.lineWrapRule = chunk.lineWrapRule;
        this.flexOffset = chunk.flexOffset;
        this.trimSpace = "pdf".equals(ExecuteContext.get().getExpType()) ? chunk.trimSpace : false;
    }

    public TextChunk(String value, ITextMeasurer measurer, LineWrapRule lineWrapRule, ITextSplitCharacter charSplitManage, boolean wordFlex, boolean trimSpace) {
        this.value = value;
        this.wordFlex = wordFlex;
        this.measurer = measurer;
        this.lineWrapRule = lineWrapRule;
        this.charSplitManage = charSplitManage;
        this.trimSpace = "pdf".equals(ExecuteContext.get().getExpType()) ? trimSpace : false;
    }

    public TextChunk split(float minWidth, float maxWidth) {
        int currentPosition = 0;
        float currentWidth = 0.0f;
        int length = this.value.length();
        int lastSplitIndex = 0;
        block0: while (currentPosition < length) {
            char c = this.value.charAt(currentPosition);
            if (this.lineWrapRule == LineWrapRule.NoWrap && c == '\n') {
                ++currentPosition;
                continue;
            }
            if (c == '\r' || c == '\n') {
                int inc = 1;
                if (c == '\r' && currentPosition + 1 < length && this.value.charAt(currentPosition + 1) == '\n') {
                    inc = 2;
                    this.hardEntry = true;
                } else if (c == '\n') {
                    this.hardEntry = true;
                }
                String returnValue = this.value.substring(currentPosition + inc);
                this.value = this.value.substring(0, currentPosition + inc);
                this.splitPosition = currentPosition + inc;
                this.calcFlexWidth(minWidth);
                return new TextChunk(returnValue, this);
            }
            boolean surrogate = Utilities.isSurrogatePair((String)this.value, (int)currentPosition);
            currentWidth = surrogate ? (currentWidth += this.measurer.charWidth(Utilities.convertToUtf32((char)this.value.charAt(currentPosition), (char)this.value.charAt(currentPosition + 1)))) : (currentWidth += this.measurer.charWidth(c));
            if (!ArrayUtils.contains((char[])this.getLineInLast(), (char)c)) {
                lastSplitIndex = currentPosition;
            }
            if (surrogate) {
                ++currentPosition;
            }
            if (this.lineWrapRule == LineWrapRule.NoWrap) {
                if (currentWidth > maxWidth) {
                    this.value = this.trim(this.value.substring(0, this.splitPosition));
                    this.flexOffset = 0.0f;
                    return null;
                }
            } else if (currentWidth > minWidth) {
                if (ArrayUtils.contains((char[])this.getLineInLast(), (char)this.value.charAt(currentPosition))) {
                    for (int preIndex = lastSplitIndex; preIndex >= 0; --preIndex) {
                        if (!this.charSplitManage.isSplitCharacter(this.value.charAt(preIndex))) continue;
                        if (ArrayUtils.contains((char[])this.getLineInBefore(), (char)this.value.charAt(preIndex)) || ArrayUtils.contains((char[])this.getLineInLast(), (char)this.value.charAt(preIndex + 1))) {
                            this.splitPosition = preIndex;
                            break block0;
                        }
                        this.splitPosition = preIndex + 1;
                        break block0;
                    }
                    break;
                }
                if (this.splitPosition > 0 && ArrayUtils.contains((char[])this.getLineInBefore(), (char)this.value.charAt(this.splitPosition - 1)) && !ArrayUtils.contains((char[])this.getLineInBefore(), (char)this.value.charAt(this.splitPosition))) {
                    --this.splitPosition;
                    break;
                }
                if (!this.charSplitManage.isSplitCharacter(this.value.charAt(currentPosition))) break;
                this.splitPosition = currentPosition;
                break;
            }
            if (this.charSplitManage.isSplitCharacter(this.value.charAt(currentPosition))) {
                this.splitPosition = currentPosition + 1;
            }
            ++currentPosition;
        }
        if (currentPosition == length) {
            this.splitPosition = length;
            this.calcFlexWidth(minWidth);
            return null;
        }
        if (this.splitPosition < 0) {
            String returnValue = this.value;
            this.value = "";
            this.flexOffset = 0.0f;
            return new TextChunk(returnValue, this);
        }
        String returnValue = this.value.substring(this.splitPosition);
        this.value = this.trim(this.value.substring(0, this.splitPosition));
        this.calcFlexWidth(minWidth);
        return new TextChunk(returnValue, this);
    }

    private void calcFlexWidth(float minWidth) {
        if (!this.wordFlex || this.lineWrapRule == LineWrapRule.NoWrap) {
            return;
        }
        float splitChunkWidth = this.measurer.stringWidth(this.value);
        if (this.value.length() < 1) {
            this.flexOffset = 0.0f;
        } else {
            float bankWidth = minWidth - splitChunkWidth;
            this.flexOffset = bankWidth / (float)(this.value.length() + 1);
            float usedRate = splitChunkWidth / minWidth;
            this.flexOffset = usedRate > 0.7f ? Math.min(this.flexOffset, splitChunkWidth / (float)((this.value.length() + 1) * 8)) : 0.0f;
        }
    }

    private String trim(String string) {
        if (!this.trimSpace) {
            return string;
        }
        while (string.endsWith(SPACE_STRING) || string.endsWith("\t")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public int length() {
        return this.value.length();
    }

    void trimLastSpace() {
        if (this.trimSpace && this.value.length() > 1 && this.value.endsWith(SPACE_STRING)) {
            this.value = this.value.substring(0, this.value.length() - 1);
        }
    }

    TextChunk truncate(float width) {
        int currentPosition;
        float currentWidth = 0.0f;
        if (width < this.measurer.charWidth(32)) {
            String returnValue = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            return new TextChunk(returnValue, this);
        }
        int length = this.value.length();
        boolean surrogate = false;
        for (currentPosition = 0; currentPosition < length; ++currentPosition) {
            surrogate = Utilities.isSurrogatePair((String)this.value, (int)currentPosition);
            currentWidth = surrogate ? (currentWidth += this.measurer.charWidth(Utilities.convertToUtf32((String)this.value, (int)currentPosition))) : (currentWidth += this.measurer.charWidth(this.value.charAt(currentPosition)));
            if (currentWidth > width) break;
            if (!surrogate) continue;
            ++currentPosition;
        }
        if (currentPosition == length) {
            return null;
        }
        if (currentPosition == 0) {
            currentPosition = 1;
            if (surrogate) {
                ++currentPosition;
            }
        }
        String returnValue = this.value.substring(currentPosition);
        this.value = this.value.substring(0, currentPosition);
        return new TextChunk(returnValue, this);
    }

    public String toString() {
        return this.value;
    }

    public float getFlexOffset() {
        return this.flexOffset;
    }

    public char[] getLineInLast() {
        return this.charSplitManage.getLastSymbol();
    }

    public char[] getLineInBefore() {
        return this.charSplitManage.getBeforeSymbol();
    }

    public static char getSpaceChar() {
        return ' ';
    }

    public boolean isHardEntry() {
        return this.hardEntry;
    }

    public float getTextWidth() {
        return this.measurer.stringWidth(this.value);
    }
}

