/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common.linewrap;

import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.execute.render.common.linewrap.TextChunk;

public class TextLine {
    private TextChunk lineChunk;
    private final float minWidth;
    private final float maxWidth;

    public TextLine(float minWidth, float maxWidth, Style style) {
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
    }

    public TextChunk addChunk(TextChunk chunk) {
        if (chunk == null || "".equals(chunk.toString())) {
            return null;
        }
        TextChunk overflow = chunk.split(this.minWidth, this.maxWidth);
        if (chunk.length() > 0) {
            if (overflow != null) {
                chunk.trimLastSpace();
            }
            this.lineChunk = chunk;
        } else if (this.lineChunk == null && overflow != null) {
            chunk = overflow;
            overflow = chunk.truncate(this.minWidth);
            if (chunk.length() > 0) {
                this.lineChunk = chunk;
                return overflow;
            }
            if (overflow != null) {
                this.lineChunk = overflow;
            }
            return null;
        }
        return overflow;
    }

    public TextChunk getCurrentChunk() {
        return this.lineChunk;
    }

    public boolean isHardEntry() {
        if (this.lineChunk != null) {
            return this.lineChunk.isHardEntry();
        }
        return false;
    }

    public String toString() {
        if (this.lineChunk == null) {
            return "";
        }
        return this.lineChunk.toString();
    }

    public boolean isEmpty() {
        return this.lineChunk == null;
    }
}

