/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common.linewrap.param;

import java.awt.Font;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.swing.KDFont;

public class LayoutAttribute {
    private String fontName;
    private float fontSize;
    private Font defaultFont;
    private float lineSpacing;
    private float wordSpacing;
    private int boldAndItalic = 0;

    public LayoutAttribute(Style style) {
        this.fontName = style.getFontName();
        this.fontSize = style.getKDFont().getSize2D();
        this.defaultFont = style.getFont();
        this.lineSpacing = style.getLinespacing();
        this.wordSpacing = style.getWordspacing();
        this.boldAndItalic += style.isBold() ? 1 : 0;
        this.boldAndItalic += style.isItalic() ? 2 : 0;
    }

    public Font createFont() {
        return KDFont.loadFontFromJAR(this.fontName, this.boldAndItalic, this.fontSize);
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Deprecated
    public int getFontSize() {
        return (int)this.fontSize;
    }

    public float getFontSizeF() {
        return this.fontSize;
    }

    @Deprecated
    public void setFontSize(int fontSize) {
        this.setFontSize((float)fontSize);
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public float getWordSpacing() {
        return this.wordSpacing;
    }
}

