/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common.linewrap.param;

import java.awt.Font;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;

public class LineWrapParam {
    private String text;
    private LineWrapRule rule;
    private Style style;
    private Font font;
    private int minW;
    private int maxW;
    private int minH;
    private int maxH;
    private int offsetY;
    private final boolean wordFlex;

    public LineWrapParam(Builder builder) {
        this.text = builder.text;
        this.rule = builder.rule;
        this.style = builder.style;
        this.font = builder.font;
        this.minW = builder.minW;
        this.maxW = builder.maxW;
        this.minH = builder.minH;
        this.maxH = builder.maxH;
        this.offsetY = builder.offsetY;
        this.wordFlex = builder.wordFlex;
    }

    public String getText() {
        return this.text;
    }

    public LineWrapRule getRule() {
        return this.rule;
    }

    public Style getStyle() {
        return this.style;
    }

    public Font getFont() {
        return this.font;
    }

    public int getMinW() {
        return this.minW;
    }

    public int getMaxW() {
        return this.maxW;
    }

    public int getMinH() {
        return this.minH;
    }

    public int getMaxH() {
        return this.maxH;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public boolean isWordFlex() {
        return this.wordFlex;
    }

    public LineWrapParam text(String text) {
        this.text = text;
        return this;
    }

    public LineWrapParam rule(LineWrapRule rule) {
        this.rule = rule;
        return this;
    }

    public LineWrapParam style(Style style) {
        this.style = style;
        return this;
    }

    public LineWrapParam font(Font font) {
        this.font = font;
        return this;
    }

    public LineWrapParam minW(int minW) {
        this.minW = minW;
        return this;
    }

    public LineWrapParam maxW(int maxW) {
        this.maxW = maxW;
        return this;
    }

    public LineWrapParam minH(int minH) {
        this.minH = minH;
        return this;
    }

    public LineWrapParam maxH(int maxH) {
        this.maxH = maxH;
        return this;
    }

    public LineWrapParam offsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    public String toString() {
        return "LineWrapParam{text='" + this.text + '\'' + ", rule=" + this.rule.ordinal() + ", minW=" + this.minW + ", maxW=" + this.maxW + ", minH=" + this.minH + ", maxH=" + this.maxH + ", offsetY=" + this.offsetY + ", wordFlex=" + this.wordFlex + '}';
    }

    public static class Builder {
        private final String text;
        private final LineWrapRule rule;
        private Style style;
        private Font font;
        private int minW;
        private int maxW;
        private int minH;
        private int maxH;
        private int offsetY;
        private boolean wordFlex;

        public Builder(String text, LineWrapRule rule) {
            this.text = text;
            this.rule = rule;
        }

        public Builder(String text, int ruleNo) {
            this.text = text;
            this.rule = LineWrapRule.getRule(ruleNo);
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public Builder font(Font font) {
            this.font = font;
            return this;
        }

        public Builder minW(int minW) {
            this.minW = minW;
            return this;
        }

        public Builder maxW(int maxW) {
            this.maxW = maxW;
            return this;
        }

        public Builder minH(int minH) {
            this.minH = minH;
            return this;
        }

        public Builder maxH(int maxH) {
            this.maxH = maxH;
            return this;
        }

        public Builder offsetY(int offsetY) {
            this.offsetY = offsetY;
            return this;
        }

        public Builder wordFlex(boolean wordFlex) {
            this.wordFlex = wordFlex;
            return this;
        }

        public LineWrapParam build() {
            if (this.style == null && this.font == null) {
                throw new IllegalArgumentException("style and font both null, missing font information !");
            }
            return new LineWrapParam(this);
        }
    }
}

