/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common.linewrap.process;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.execute.render.common.linewrap.ILineWrapSymbols;
import kd.bos.print.core.execute.render.common.linewrap.ITextMeasurer;
import kd.bos.print.core.execute.render.common.linewrap.TextChunk;
import kd.bos.print.core.execute.render.common.linewrap.TextLine;
import kd.bos.print.core.execute.render.common.linewrap.param.LayoutAttribute;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapSymbolType;
import kd.bos.print.core.execute.render.common.linewrap.process.TruncWrapProcess;
import kd.bos.print.core.execute.render.common.linewrap.split.ChunkSplitCharacter;
import kd.bos.print.core.execute.render.common.linewrap.split.ForceSplitCharacter;
import kd.bos.print.core.execute.render.common.linewrap.split.ITextSplitCharacter;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.LineWrapEvent;

public abstract class AbstractWrapProcess<T>
implements ITextMeasurer,
ILineWrapSymbols {
    protected String text;
    protected LineWrapRule rule;
    private final ITextSplitCharacter charSplitManage;
    protected List<TextLine> lines = null;
    protected TextLine line = null;
    protected int minWidth;
    protected int maxWidth;
    protected Style style;
    protected Font font;
    protected FontMetrics fontMetrics;
    protected LineMetrics lineMetrics;
    private char[] lastSymbol = new char[]{',', ';', ':', '?', '!', '>', ')', '}', ']', '\u2026', '\uff0c', '\u3002', '\uff1b', '\uff1a', '\uff1f', '\uff01', '\u300b', '\uff09', '\uff5d', '\u3011', '\u201d', '\u2019', '\u00d7', '%', '*', '#', '\u2014', '\u3001'};
    private char[] beforeSymbol = new char[]{'<', '(', '[', '{', '\u3010', '\u300a', '\uff08', '\uff5b', '\u2018', '\u201c', '\uffe5', '$', '\u00a5', '+'};
    private char[] splitSymbol = new char[]{TextChunk.getSpaceChar(), '\u2010', '=', '&', '-'};
    private char[] noSplitSymbol = new char[0];
    protected ITextMeasurer textMeasurer;
    protected static PdfGraphics2D graphics2D = new PdfGraphics2D(new PdfContentByte(null), 10.0f, 10.0f){
        private FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, true);

        public FontRenderContext getFontRenderContext() {
            return this.fontRenderContext;
        }
    };

    AbstractWrapProcess(LineWrapParam param) {
        this.text = param.getText();
        this.rule = param.getRule();
        this.style = param.getStyle();
        this.minWidth = param.getMinW();
        this.maxWidth = param.getMaxW();
        if (param.getStyle() != null) {
            this.font = new LayoutAttribute(param.getStyle()).createFont();
            Rect padding = this.style.getPadding();
            int padWidth = padding.getLeft() + padding.getRight();
            this.maxWidth -= padWidth;
            this.minWidth -= padWidth;
        } else {
            this.font = param.getFont();
        }
        this.fontMetrics = this.getFontMetrics(this.font);
        this.lineMetrics = this.font.getLineMetrics(this.text, graphics2D.getFontRenderContext());
        this.charSplitManage = param.getRule().ordinal() > 0 ? ForceSplitCharacter.FORCE : ChunkSplitCharacter.CHUNK;
        this.firePluginEvent();
    }

    protected FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    private void firePluginEvent() {
        if (this.charSplitManage instanceof ChunkSplitCharacter) {
            PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
            if (pluginProxy != null) {
                LineWrapEvent evt = new LineWrapEvent(this);
                pluginProxy.fireBeforeLineWrap(evt);
            }
            ChunkSplitCharacter chunkSplitCharacter = (ChunkSplitCharacter)this.charSplitManage;
            chunkSplitCharacter.setProcess(this);
        }
    }

    @Override
    public float charWidth(int c) {
        if (this.noPrint(c)) {
            return 0.0f;
        }
        if (this.textMeasurer != null) {
            return this.textMeasurer.charWidth(c);
        }
        return (float)this.fontMetrics.getStringBounds(String.valueOf((char)c), (Graphics)graphics2D).getWidth();
    }

    @Override
    public float stringWidth(String str) {
        if (this.textMeasurer != null) {
            return this.textMeasurer.stringWidth(str);
        }
        return (float)this.fontMetrics.getStringBounds(String.valueOf(str), (Graphics)graphics2D).getWidth();
    }

    protected boolean noPrint(int c) {
        return c >= 8203 && c <= 8207 || c >= 8234 && c <= 8238;
    }

    public final T process(boolean wordFlex) {
        return this.process(wordFlex, !(this instanceof TruncWrapProcess));
    }

    public final T process(boolean wordFlex, boolean trimSpace) {
        TextChunk overflow;
        if (this.notExecuteProcess()) {
            return this.createResult();
        }
        TextChunk chunk = new TextChunk(this.text, this, this.rule, this.charSplitManage, wordFlex, trimSpace);
        this.carriageReturn();
        while ((overflow = this.line.addChunk(chunk)) != null) {
            this.carriageReturn();
            chunk = overflow;
        }
        this.carriageReturn();
        return this.createResult();
    }

    protected boolean notExecuteProcess() {
        return false;
    }

    protected abstract T createResult();

    private void carriageReturn() {
        if (this.lines == null) {
            this.lines = new ArrayList<TextLine>(10);
        }
        if (this.line != null && !this.line.isEmpty()) {
            this.carriageResult();
        }
        this.line = new TextLine(this.minWidth, this.maxWidth, this.style);
    }

    protected void carriageResult() {
        this.lines.add(this.line);
    }

    @Deprecated
    public static int getLineHeight(FontMetrics fontMetrics) {
        return fontMetrics.getAscent() + fontMetrics.getDescent();
    }

    public static float getLineHeight(LineMetrics lineMetrics) {
        return lineMetrics.getAscent() + lineMetrics.getDescent();
    }

    public static float getLineHeight(LineMetrics lineMetrics, Style style) {
        if (style != null) {
            return AbstractWrapProcess.getLineHeight(lineMetrics) * style.getLineSpaceB() + style.getLinespacing();
        }
        return AbstractWrapProcess.getLineHeight(lineMetrics);
    }

    public String toString() {
        if (this.lines == null) {
            return super.toString();
        }
        return this.textToDraw();
    }

    protected float[] getFlexOffsets() {
        if (this.lines == null) {
            return null;
        }
        float[] flexOffset = new float[this.lines.size()];
        for (int i = 0; i < this.lines.size(); ++i) {
            TextChunk currentChunk = this.lines.get(i).getCurrentChunk();
            if (currentChunk == null) continue;
            flexOffset[i] = currentChunk.getFlexOffset();
        }
        return flexOffset;
    }

    protected String textToDraw() {
        return this.lineToText(this.lines);
    }

    protected String lineToText(List<TextLine> lines) {
        if (lines == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            TextLine textLine = lines.get(i);
            res.append(textLine.toString());
            if (i == lines.size() - 1 || textLine.isHardEntry() || "xls".equals(ExecuteContext.get().getExpType())) continue;
            res.append("\n");
        }
        return res.toString();
    }

    protected String lineToOriText(List<TextLine> lines) {
        if (lines == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (TextLine textLine : lines) {
            res.append(textLine.toString());
        }
        return res.toString();
    }

    public char[] getLastSymbol() {
        return this.lastSymbol;
    }

    public char[] getBeforeSymbol() {
        return this.beforeSymbol;
    }

    public char[] getSplitSymbol() {
        return this.splitSymbol;
    }

    public char[] getNoSplitSymbol() {
        return this.noSplitSymbol;
    }

    public void setLastSymbol(char[] lastSymbol) {
        this.lastSymbol = lastSymbol;
    }

    public void setBeforeSymbol(char[] beforeSymbol) {
        this.beforeSymbol = beforeSymbol;
    }

    public void setSplitSymbol(char[] splitSymbol) {
        this.splitSymbol = splitSymbol;
    }

    public void setNoSplitSymbol(char[] noSplitSymbol) {
        this.noSplitSymbol = noSplitSymbol;
    }

    @Override
    public char[] getSymbols(LineWrapSymbolType type) {
        switch (type) {
            case BEFORE_SYMBOL: {
                return this.getBeforeSymbol();
            }
            case LAST_SYMBOL: {
                return this.getLastSymbol();
            }
            case SPLIT_SYMBOL: {
                return this.getSplitSymbol();
            }
            case NO_SPLIT_SYMBOL: {
                return this.getNoSplitSymbol();
            }
        }
        return new char[0];
    }

    @Override
    public void setSymbols(char[] symbols, LineWrapSymbolType type) {
        switch (type) {
            case BEFORE_SYMBOL: {
                this.setBeforeSymbol(symbols);
                break;
            }
            case LAST_SYMBOL: {
                this.setLastSymbol(symbols);
                break;
            }
            case SPLIT_SYMBOL: {
                this.setSplitSymbol(symbols);
                break;
            }
            case NO_SPLIT_SYMBOL: {
                this.setNoSplitSymbol(symbols);
                break;
            }
        }
    }
}

