/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common.linewrap.process;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.LineMetrics;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.util.FontUtil;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.esc.EscUtil;
import kd.bos.print.core.execute.render.common.AdjustHeightInfo;
import kd.bos.print.core.execute.render.common.linewrap.ITextMeasurer;
import kd.bos.print.core.execute.render.common.linewrap.TextLine;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.process.AbstractWrapProcess;

public class AdjustWrapProcess
extends AbstractWrapProcess<AdjustHeightInfo> {
    private List<TextLine> remindLines = null;
    protected int minHeight;
    protected int maxHeight;
    protected double currentHeight;

    public AdjustWrapProcess(LineWrapParam param) {
        super(param);
        this.minHeight = param.getMinH() - param.getOffsetY();
        this.maxHeight = param.getMaxH() - param.getOffsetY();
        if ("escp".equals(ExecuteContext.get().getExpType())) {
            this.textMeasurer = new ITextMeasurer(){

                @Override
                public float charWidth(int codePoint) {
                    if (EscUtil.isDoubleWidth((char)codePoint)) {
                        return (float)KPrintUtil.lomToPrintPoint(42.38333384195964);
                    }
                    return (float)KPrintUtil.lomToPrintPoint(21.19166692097982);
                }

                @Override
                public float stringWidth(String str) {
                    if (StringUtils.isBlank((CharSequence)str)) {
                        return 0.0f;
                    }
                    float result = 0.0f;
                    for (int i = 0; i < str.length(); ++i) {
                        result += this.charWidth(str.charAt(i));
                    }
                    return result;
                }

                @Override
                public float calculateLineHeight(LineMetrics lineMetrics, Style style) {
                    return (float)KPrintUtil.lomToPrintPoint(35.3194448682997);
                }

                @Override
                public float calculateTotalRowHeight(int rowNum, LineMetrics lineMetrics, Style style) {
                    return ITextMeasurer.super.calculateTotalRowHeight(rowNum + 1, lineMetrics, style);
                }
            };
        }
    }

    @Override
    protected boolean notExecuteProcess() {
        return this.minWidth <= 0;
    }

    @Override
    protected AdjustHeightInfo createResult() {
        if (this.lines == null) {
            AdjustHeightInfo result = new AdjustHeightInfo(this.minHeight, "", null);
            result.setTextHeight(0);
            result.setUsedHeight(this.minHeight);
            return result;
        }
        this.currentHeight = (int)Math.ceil(this.calculateTotalRowHeight(this.lines.size(), this.lineMetrics, this.style));
        String textToDraw = this.textToDraw();
        String textRemind = this.textRemind();
        double usedHeight = Math.max(this.currentHeight, (double)this.minHeight);
        if (StringUtils.isNotBlank((CharSequence)textToDraw) && textToDraw.endsWith("\n")) {
            textToDraw = textToDraw.substring(0, textToDraw.lastIndexOf("\n"));
        }
        AdjustHeightInfo result = new AdjustHeightInfo((int)usedHeight, textToDraw, textRemind);
        result.setTextHeight((int)this.currentHeight);
        result.setUsedHeight((int)usedHeight);
        float oneLineHeight = this.calculateLineHeight(this.lineMetrics, this.style);
        if (oneLineHeight > (float)this.maxHeight) {
            result.setUsedHeight(this.maxHeight + 1);
            result.setTextHeight(this.maxHeight + 1);
        }
        result.setCutOff(!textToDraw.equals(textRemind));
        result.setThrowAwayField(false);
        float[] flexOffset = this.getFlexOffsets();
        result.setFlexOffset(flexOffset);
        this.finish();
        return result;
    }

    @Override
    public float charWidth(int c) {
        if (this.textMeasurer != null) {
            return this.textMeasurer.charWidth(c);
        }
        if (this.noPrint(c)) {
            return 0.0f;
        }
        if (!this.font.canDisplay(c)) {
            FontMetrics fontMetrics = this.getFontMetrics(FontUtil.createSimSunFont(this.font));
            return (float)fontMetrics.getStringBounds(String.valueOf((char)c), (Graphics)graphics2D).getWidth();
        }
        return (float)this.fontMetrics.getStringBounds(String.valueOf((char)c), (Graphics)graphics2D).getWidth();
    }

    @Override
    protected float[] getFlexOffsets() {
        float[] flexOffset = super.getFlexOffsets();
        if (flexOffset == null) {
            return null;
        }
        if (this.lines.size() > 0 && CollectionUtils.isEmpty(this.remindLines)) {
            flexOffset[this.lines.size() - 1] = 0.0f;
        }
        return flexOffset;
    }

    private void finish() {
        if (this.lines != null) {
            this.lines.clear();
        }
        if (this.remindLines != null) {
            this.remindLines.clear();
        }
    }

    @Override
    protected void carriageResult() {
        this.currentHeight += (double)this.calculateLineHeight(this.lineMetrics, this.style);
        if (this.currentHeight < (double)this.maxHeight) {
            this.lines.add(this.line);
        } else {
            if (this.remindLines == null) {
                this.remindLines = new ArrayList<TextLine>(10);
            }
            this.remindLines.add(this.line);
        }
    }

    @Override
    public float calculateLineHeight(LineMetrics lineMetrics, Style style) {
        if (this.textMeasurer != null) {
            return this.textMeasurer.calculateLineHeight(lineMetrics, style);
        }
        return super.calculateLineHeight(lineMetrics, style);
    }

    @Override
    public float calculateTotalRowHeight(int rowNum, LineMetrics lineMetrics, Style style) {
        if (this.textMeasurer != null) {
            return this.textMeasurer.calculateTotalRowHeight(rowNum, lineMetrics, style);
        }
        return super.calculateTotalRowHeight(rowNum, lineMetrics, style);
    }

    private String textRemind() {
        return this.lineToOriText(this.remindLines);
    }
}

