/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common.linewrap.process;

import java.awt.FontMetrics;
import kd.bos.print.core.ctrl.common.util.FontUtil;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;
import kd.bos.print.core.execute.render.common.linewrap.process.AbstractWrapProcess;

public class ShrinkWrapProcess
extends AbstractWrapProcess<ShrinkWrapInfo> {
    public ShrinkWrapProcess(LineWrapParam param) {
        super(param);
    }

    @Override
    protected boolean notExecuteProcess() {
        return this.rule == LineWrapRule.NoWrap;
    }

    @Override
    protected ShrinkWrapInfo createResult() {
        return new ShrinkWrapInfo(this.rule == LineWrapRule.NoWrap ? this.text.replaceAll("\n", "") : this.textToDraw(), this.getFlexOffsets());
    }

    @Override
    protected float[] getFlexOffsets() {
        float[] flexOffset = super.getFlexOffsets();
        if (flexOffset == null) {
            return null;
        }
        if (this.lines.size() > 0) {
            flexOffset[this.lines.size() - 1] = 0.0f;
        }
        return flexOffset;
    }

    @Override
    public float charWidth(int c) {
        if (this.noPrint(c)) {
            return 0.0f;
        }
        if (!this.font.canDisplay(c)) {
            FontMetrics fontMetrics = this.getFontMetrics(FontUtil.createSimSunFont(this.font));
            return fontMetrics.charWidth(c);
        }
        return this.fontMetrics.charWidth(c);
    }

    @Override
    public float stringWidth(String str) {
        float sum = 0.0f;
        for (int i = 0; i < str.length(); ++i) {
            float add = this.charWidth(str.charAt(i));
            sum += add;
        }
        return sum;
    }

    public static class ShrinkWrapInfo {
        private final String text;
        private final float[] flexOffset;

        public ShrinkWrapInfo(String text, float[] flexOffset) {
            this.text = text;
            this.flexOffset = flexOffset;
        }

        public String getText() {
            return this.text;
        }

        public float[] getFlexOffset() {
            return this.flexOffset;
        }
    }
}

