/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.common.linewrap.process;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.print.core.execute.render.common.linewrap.TextChunk;
import kd.bos.print.core.execute.render.common.linewrap.TextLine;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.process.AbstractWrapProcess;

public class TruncWrapProcess
extends AbstractWrapProcess<TruncWrapInfo> {
    public TruncWrapProcess(LineWrapParam param) {
        super(param);
    }

    @Override
    protected TruncWrapInfo createResult() {
        int[] positions = new int[this.lines.size()];
        float[] flexOffset = new float[this.lines.size()];
        float[] textWidths = new float[this.lines.size()];
        int position = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            TextLine textLine = (TextLine)this.lines.get(i);
            TextChunk chunk = textLine.getCurrentChunk();
            if (chunk == null) continue;
            positions[i] = position += chunk.length();
            flexOffset[i] = chunk.getFlexOffset();
            textWidths[i] = chunk.getTextWidth();
        }
        return new TruncWrapInfo(positions, flexOffset, textWidths);
    }

    @Override
    protected float[] getFlexOffsets() {
        float[] flexOffset = super.getFlexOffsets();
        if (flexOffset == null) {
            return null;
        }
        if (this.lines.size() > 0) {
            flexOffset[this.lines.size() - 1] = 0.0f;
        }
        return flexOffset;
    }

    @Override
    public float charWidth(int c) {
        if (!this.font.canDisplay(c)) {
            HashMap<TextAttribute, String> map = new HashMap<TextAttribute, String>(1);
            map.put(TextAttribute.FAMILY, "Source Han Serif CN");
            FontMetrics fontMetrics = this.getFontMetrics(this.font.deriveFont(map));
            return (float)fontMetrics.getStringBounds(String.valueOf((char)c), (Graphics)graphics2D).getWidth();
        }
        return (float)this.fontMetrics.getStringBounds(String.valueOf((char)c), (Graphics)graphics2D).getWidth();
    }

    public static class SplitPosItr
    implements Iterator<TruncWrapInfo> {
        private int curIndex;
        private final int[] positions;
        private final float[] flexOffsets;
        private float[] textWidth;

        public SplitPosItr(int[] positions, float[] flexOffsets) {
            this.positions = positions;
            this.flexOffsets = flexOffsets;
        }

        public SplitPosItr(int[] positions, float[] flexOffsets, float[] textWidth) {
            this(positions, flexOffsets);
            this.textWidth = textWidth;
        }

        @Override
        public boolean hasNext() {
            return this.positions != null && this.curIndex < this.positions.length;
        }

        @Override
        public TruncWrapInfo next() {
            TruncWrapInfo truncWrapInfo = new TruncWrapInfo();
            truncWrapInfo.setSplitPosition(this.positions[this.curIndex]);
            truncWrapInfo.setTextWidth(this.textWidth[this.curIndex]);
            if (this.flexOffsets != null && this.curIndex >= 0 && this.curIndex < this.flexOffsets.length) {
                truncWrapInfo.setFlexOffset(this.flexOffsets[this.curIndex]);
            } else {
                truncWrapInfo.setFlexOffset(0.0f);
            }
            ++this.curIndex;
            return truncWrapInfo;
        }
    }

    public static class TruncWrapInfo
    implements Iterable<TruncWrapInfo> {
        private SplitPosItr splitPosItr;
        private int splitPosition;
        private float flexOffset;
        private float textWidth;

        public TruncWrapInfo() {
        }

        public TruncWrapInfo(int[] positions, float[] flexOffsets) {
            this.splitPosItr = new SplitPosItr(positions, flexOffsets);
        }

        public TruncWrapInfo(int[] positions, float[] flexOffsets, float[] textWidths) {
            this.splitPosItr = new SplitPosItr(positions, flexOffsets, textWidths);
        }

        @Override
        public Iterator<TruncWrapInfo> iterator() {
            return this.splitPosItr;
        }

        public int getSplitPosition() {
            return this.splitPosition;
        }

        public void setSplitPosition(int splitPosition) {
            this.splitPosition = splitPosition;
        }

        public float getFlexOffset() {
            return this.flexOffset;
        }

        public void setFlexOffset(float flexOffset) {
            this.flexOffset = flexOffset;
        }

        public float getTextWidth() {
            return this.textWidth;
        }

        public void setTextWidth(float textWidth) {
            this.textWidth = textWidth;
        }
    }
}

