/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.OutputStream;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.print.io.WatermarkPageEvent;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.render.export.AbstractPrtExport;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.BasePainter;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.model.widget.PWPageEnum;

public abstract class AbstractPdfExport<P extends APaperPainter>
extends AbstractPrtExport<P> {
    protected Document document;
    private PdfContentByte pdfContentByte;

    @Override
    public void begin(P paper) {
        super.begin(paper);
        try {
            this.document = new Document();
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.os);
            PaintPaperInfo printInfo = ((BasePainter)paper).getPaperInfo();
            if (printInfo.getWaterMark() != null) {
                WatermarkPageEvent watermarkEvent = new WatermarkPageEvent();
                watermarkEvent.setWaterMark(printInfo.getWaterMark());
                pdfWriter.setPageEvent((PdfPageEvent)watermarkEvent);
            }
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
        }
        catch (DocumentException e) {
            throw new RuntimeException("PDF Document error:" + e.getMessage(), e);
        }
    }

    @Override
    public void export(P painter) {
        String pageNumType;
        if (this.document == null) {
            this.begin(painter);
        }
        PaintPaperInfo printInfo = ((BasePainter)painter).getPaperInfo();
        R1PrintInfo r1PrintInfo = printInfo.getR1PrintInfo();
        Dimension paperDim = r1PrintInfo.getPaperSize();
        float widthPt = (float)StyleUtil.lomToPt(paperDim.width);
        float heightPt = (float)StyleUtil.lomToPt(paperDim.height);
        Rectangle rc = new Rectangle(widthPt, heightPt);
        this.document.setPageSize(rc);
        this.document.newPage();
        PdfTemplate pdftemplate = this.pdfContentByte.createTemplate(widthPt, heightPt);
        Graphics2D graphics2d = pdftemplate.createGraphics(widthPt, heightPt, this.DEFAULT_FONTMAPPER);
        graphics2d.scale(72.0 / (double)KDToolkit.getCurrentDpi(), 72.0 / (double)KDToolkit.getCurrentDpi());
        ((BasePainter)painter).getPaintContext().setPdftemplate(pdftemplate);
        ((BasePainter)painter).paint(graphics2d);
        graphics2d.dispose();
        this.pdfContentByte.addTemplate(pdftemplate, 0.0f, 0.0f);
        ++this.curExpPageSize;
        if (((BasePainter)painter).getPaintObj() == PWPageEnum.INSTANCE.getEmptyPage() && !"2".equals(pageNumType = ExecuteContext.get().getPageNumType())) {
            this.share.getDisablePageSize().incrementAndGet();
        }
    }

    @Override
    protected String getFileNameSuffix() {
        return "pdf";
    }
}

